package cn.com.duiba.activity.custom.center.api.enums.identity;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/8/19 上午10:29
 */
public enum  IdentityNewRelTypeEnum {
    /**
     * app_id=-1L:所有app通用
     * rel_type=-1:为当前app_id定制有效
     * app_id + rel_type为key
     */

    // 通用rel_type
    MOBILE(-1L,1,"手机号码"),

    // 特殊定制
    // rel_type 代表每次导入期次
    WHITE_LIST(82461L,-1,"太原中信-地铁活动白名单"),

    // 唯一对应
    BETAID(77780L,2,"宁波银行定制dcustom参数"),
    EQUITY_ORDER(70784L,2,"青海中行-商户权益核销记录关联订单id"),
    OPENID_AND_UNIONID(82066L,2,"山东银联定制-openId和unionId映射关系"),
    BLIND_BOX(19592L,2,"智己汽车-用户与盲盒关联"),
    //由于1已经被人使用，所以浙江银联用2来保存手机号
    ZJUNION_MOBILE(90195L,2,"浙江银联-用户绑定手机号"),
    CITIC_EXCHANGE(85545L,2,"中信-普兑"),
    CITIC_SEC(85545L,3,"中信-秒杀"),
    FUJIAN_OPENID(80166L,2,"福建中行-用户绑定手机号关联表"),

    ;


    private Long appId;
    private Integer relType;
    private String desc;

    IdentityNewRelTypeEnum(Long appId, Integer relType, String desc) {
        this.appId = appId;
        this.relType = relType;
        this.desc = desc;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getRelType() {
        return relType;
    }

    public void setRelType(Integer relType) {
        this.relType = relType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
