package cn.com.duiba.activity.custom.center.api.remoteservice.qingdao;

import cn.com.duiba.activity.custom.center.api.dto.qingdao.QueryManyUserTaskFinishDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.QueryTaskFinishDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.UserFinishTaskDto;
import cn.com.duiba.activity.custom.center.api.dto.qingdao.UserReceiveCreditDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/11/30 17
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteUserReceiveCreditService {

    Long save(UserReceiveCreditDto userReceiveCreditDto);

    Integer updateById(UserReceiveCreditDto userReceiveCreditDto);

    UserReceiveCreditDto getById(Long id);

    /**
     * 用户待领取积分列表
     *
     * @param userReceiveCreditDto
     * @return
     */
    List<UserReceiveCreditDto> queryWaitReceiveList(UserReceiveCreditDto userReceiveCreditDto);

    /**
     * 用户待领取积分总值
     *
     * @param userReceiveCreditDto
     * @return
     */
    Long queryWaitReceiveCredits(UserReceiveCreditDto userReceiveCreditDto);

    /**
     * 用户维度批量更新为已领取
     *
     * @param userReceiveCreditDtoList
     * @return
     */
    Integer batchUpdateStatus(List<UserReceiveCreditDto> userReceiveCreditDtoList);

    /**
     * 批量查询用户任务已完成的次数（基础、高级过期时间不同，自行区分）
     *
     * @param queryTaskFinishDto
     * @return
     */
    List<UserFinishTaskDto> batchQueryUserTasksFinishNum(QueryTaskFinishDto queryTaskFinishDto);


    /**
     * 批量多用户单任务查询
     *
     * @param queryTaskFinishDto
     * @return
     */
    List<UserFinishTaskDto> batchManyUserTaskFinishNum(QueryManyUserTaskFinishDto queryTaskFinishDto);

    /**
     * 批量插入多条待领取积分
     *
     * @param userReceiveCreditDtoList
     * @param processKey               redis缓存数据的args
     * @return
     */
    Integer batchInsert(List<UserReceiveCreditDto> userReceiveCreditDtoList, String processKey);

    /**
     * 批量插入多条用户数据
     *
     * @param userReceiveCreditDtoList
     * @return
     */
    Integer batchInsertDetail(List<UserReceiveCreditDto> userReceiveCreditDtoList);
}
