package cn.com.duiba.activity.custom.center.api.remoteservice.wechat;

import cn.com.duiba.activity.custom.center.api.dto.wechat.WxUserEventTplBean;
import cn.com.duiba.activity.custom.center.api.enums.wechat.WechatTemplateEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/6/14 16:32
 */
@AdvancedFeignClient
public interface RemoteWechatPushTplMsgService {
    /**
     * 微信模板消息推送
     * @param data 推送模板数据 https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1433751277
     * @param consumerIds 接收用户，partnerUserId一定要是微信的openID
     * @param templateEnum 推送模板
     * @param url 链接
     */
    void pushWechatMessage(JSONObject data, List<Long> consumerIds, WechatTemplateEnum templateEnum, String url);

    /**
     * 微信模板消息推送(与上面的区别在于,第二个参数不同)
     * @param data
     * @param wxUserEventTplBeans
     * @param templateEnum
     * @param url
     */
    void putBasicMessage(JSONObject data, List<WxUserEventTplBean> wxUserEventTplBeans, WechatTemplateEnum templateEnum, String url);
}
