package cn.com.duiba.activity.custom.center.api.remoteservice.yonghui;

import cn.com.duiba.activity.custom.center.api.dto.yonghui.NewUserHelpListDto;
import cn.com.duiba.activity.custom.center.api.dto.yonghui.NewUserHelpListParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 永辉新人活动
 */
@AdvancedFeignClient
public interface RemoteNewUserHelpListService {

    /**
     * 插入
     *
     * @param pojo
     * @return
     */
    Long insert(NewUserHelpListDto pojo);


    /**
     * 查询
     *
     * @param pojo
     * @return
     */
    List<NewUserHelpListDto> selectList(NewUserHelpListParam pojo);


    List<NewUserHelpListDto> selectListV4(NewUserHelpListParam pojo);

    /**
     * 修改
     *
     * @param pojo
     * @return
     */
    Integer updateById(NewUserHelpListDto pojo);

    /**
     * 统计个数
     *
     * @param pojo
     * @return
     */
    Long count(NewUserHelpListParam pojo);

    /**
     * helpConsumerId+consumerId+prizeType可能会有多条数据，
     * <p>
     * 这里取按照创建时间倒序第一条
     *
     * @param helpConsumerId 助力人，唯一
     * @param consumerId     被助力人
     * @return
     */
    NewUserHelpListDto findTopByHelpConsumerIdAndConsumerId(Long helpConsumerId, Long consumerId, List<Integer> prizeTypes);


    /**
     * 这里取按照创建时间倒序第一条
     *
     * @param helpConsumerId
     * @param helpStatus
     * @return
     */
    NewUserHelpListDto findTopByHelpConsumerIdAndHelpStatus(Long helpConsumerId, Integer helpStatus);
}
