package cn.com.duiba.activity.custom.center.api.enums.validate;

import java.util.Objects;

/**
 * @program: activity-custom-center
 * @description: 活动校验类型枚举
 * @author: Simba
 * @create: 2019-07-12 14:57
 **/
public enum ActivityValidateTypeEnum {

    SLIDE(1, "滑块校验"),
    CLICK(2, "点击校验"),
    ;
    private Integer code;
    private String desc;

    ActivityValidateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ActivityValidateTypeEnum ofValue(Integer code) {
        for (ActivityValidateTypeEnum validateTypeEnum : values()) {
            if (Objects.equals(validateTypeEnum.getCode(), code)) {
                return validateTypeEnum;
            }
        }
        return null;
    }
}

