/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.custom.center.api.enums.citic;

import cn.com.duiba.boot.exception.BizException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MonthTypeEnum {
    NEXT_MONTH(1, "\u4e0b\u4e2a\u6708"),
    CURRENT_MONTH(2, "\u5f53\u6708"),
    LAST_MONTH(3, "\u4e0a\u4e2a\u6708"),
    LAST_TWO_MONTH(4, "\u4e0a\u4e0a\u4e2a\u6708");

    private Integer type;
    private String desc;
    private static final Map<Integer, MonthTypeEnum> ENUM_MAP;
    private static final Logger LOGGER;

    private MonthTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static int getBelongMonth(int monthType) throws BizException {
        Calendar rightNow;
        SimpleDateFormat MONTH_NUMBER = new SimpleDateFormat("yyyyMM");
        Date date = new Date();
        if (monthType == MonthTypeEnum.CURRENT_MONTH.type) {
            date = new Date();
        } else if (monthType == MonthTypeEnum.NEXT_MONTH.type) {
            rightNow = Calendar.getInstance();
            rightNow.setTime(date);
            rightNow.add(2, 1);
            date = rightNow.getTime();
        } else if (monthType == MonthTypeEnum.LAST_MONTH.type) {
            rightNow = Calendar.getInstance();
            rightNow.setTime(date);
            rightNow.add(2, -1);
            date = rightNow.getTime();
        } else if (monthType == MonthTypeEnum.LAST_TWO_MONTH.type) {
            rightNow = Calendar.getInstance();
            rightNow.setTime(date);
            rightNow.add(2, -2);
            date = rightNow.getTime();
        } else {
            throw new BizException("\u672a\u77e5\u6708\u4efd\u7c7b\u578b");
        }
        Integer belongMonth = Integer.valueOf(MONTH_NUMBER.format(date));
        LOGGER.info("monthType:{},belongMonth:{},now:{}", new Object[]{monthType, belongMonth, System.currentTimeMillis()});
        return belongMonth;
    }

    public static MonthTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    static {
        ENUM_MAP = new HashMap<Integer, MonthTypeEnum>();
        LOGGER = LoggerFactory.getLogger(MonthTypeEnum.class);
        for (MonthTypeEnum tmp : MonthTypeEnum.values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
}

