package cn.com.duiba.activity.custom.center.api.enums.ccb;

import java.util.HashMap;
import java.util.Map;

/**
 * 供应商枚举
 */
public enum SupplierEntityEnum {


    /**
     * duiba 柜台号
     */
    Duiba(1, "038876598"),
    /**
     * 卡赢
     */
    CARD_WINNER(2,"039214581"),
    /**
     * 微能
     */
    WEI_NENG(3,"0392388103"),
    /**
     * 好礼赚不停 加活动次数
     */
    BIG_WHEEL(4, "039214581"),
    /**
     * 联海
     */
    LIAN_HAI(5, "039314146"),

    /**
     * 般豆
     */
    BAN_DOU(6, "043729810"),

    /**
     * 盈天地
     */
    YTD(7, "045255534"),

    /**
     * 般豆,仅限信用卡支付
     */
    ONLY_CREDIT(8, "049919746"),
    ;

    private Integer code;

    /**
     * 柜台号
     */
    private String posId;

    private static final Map<Integer, SupplierEntityEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SupplierEntityEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    SupplierEntityEnum(Integer code, String posId) {
        this.code = code;
        this.posId = posId;
    }

    public Integer getCode() {
        return code;
    }

    public String getPosId() {
        return posId;
    }

    public static SupplierEntityEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
