package cn.com.duiba.activity.custom.center.api.enums.watsons;

import java.util.HashMap;
import java.util.Map;

public enum WatsonsJoinGroupTypeEnum {

    FIVE_CREDITS(5, "5积分"),
    TEN_CREDITS(10, "10积分"),
    TWENTY_CREDITS(20, "20积分"),
    THIRTY_CREDITS(30, "30积分"),
    FORTY_CREDITS(40, "40积分"),
    ;

    WatsonsJoinGroupTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, WatsonsJoinGroupTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (WatsonsJoinGroupTypeEnum typeEnum : WatsonsJoinGroupTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getType(), typeEnum);
        }
    }

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static WatsonsJoinGroupTypeEnum getByType(Integer type) {
        return typeEnumMap.get(type);
    }

}

