package cn.com.duiba.activity.custom.center.api.remoteservice.citic;

import cn.com.duiba.activity.custom.center.api.dto.citic.CiticActivityRecordDto;
import cn.com.duiba.activity.custom.center.api.dto.citic.ConsumerActivityIdentityDto;
import cn.com.duiba.activity.custom.center.api.params.citic.CiticActivityRecordParam;
import cn.com.duiba.activity.custom.center.api.params.citic.CiticConsumerActivityParam;
import cn.com.duiba.activity.custom.center.api.params.citic.CiticUpdateParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/8/29 11
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteCiticActivityRecordService {

    int batchInsert(List<CiticActivityRecordDto> citicActivityRecordDtoList);

    int deleteById(Long id);

    Page<CiticActivityRecordDto> pageByCondition(CiticActivityRecordParam param) throws BizException;

    CiticActivityRecordDto getById(Long id);

    /**
     * 黑名单列表,确定使用哪个月份
     * @param param
     */
    CiticActivityRecordDto getBlackMonthByOne(CiticActivityRecordParam param);

    int batchUpdate(CiticUpdateParam citicUpdateParam);

    /**
     * 查询用户当前时间参与活动的资格信息
     * @param citicConsumerActivityParam
     * @return
     */
    ConsumerActivityIdentityDto getConsumerCurrentQualification(CiticConsumerActivityParam citicConsumerActivityParam);

}
