package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear.tuia;

import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearAllDto;
import cn.com.duiba.activity.custom.center.api.enums.happyclear.HappyClearAwardBizTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 推啊-定制消消乐（投放到趣闻APP）,看视频额外奖励触发前置标记
 *
 * @author fxr
 * @date 2019-12-26
 */
@AdvancedFeignClient
public interface RemoteHappyClearExtraAwardMarkService {
    /**
     * Sets mark *
     * 此方法内含定制权限校验，调用方无需在调用前进行定制权限校验
     *
     * @param appId        app id
     * @param consumerId   consumer id
     * @param activityId   activityId
     * @param bizType      {@link HappyClearAwardBizTypeEnum#getCode()}
     * @param winningPrize winning prize
     */
    void setMark(Long appId, Long consumerId, Long activityId, Integer bizType, HappyClearAllDto winningPrize);

    /**
     * Remove mark *
     * 此方法内含定制权限校验，调用方无需在调用前进行定制权限校验
     *
     * @param appId      app id
     * @param consumerId consumer id
     * @param activityId activity id
     * @param bizType    {@link HappyClearAwardBizTypeEnum#getCode()}
     */
    void removeMark(Long appId, Long consumerId, Long activityId, Integer bizType);

    /**
     * Gets mark *
     * 此方法内含定制权限校验，调用方无需在调用前进行定制权限校验Ò
     *
     * @param appId      app id
     * @param consumerId consumer id
     * @param activityId activity id
     * @param bizType    {@link HappyClearAwardBizTypeEnum#getCode()}
     * @return String
     */
    String getMark(Long appId, Long consumerId, Long activityId, Integer bizType);
}
