package cn.com.duiba.activity.custom.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.custom.center.api.dto.hsbc.HsbcWithdrawDataRecordDto;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcChangeStatusParam;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcCurrentAccountParam;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcCurrentDeviceParam;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcCurrentGearParam;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcListRollbackParam;
import cn.com.duiba.activity.custom.center.api.params.hsbc.HsbcTotalLimitParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/10/10 10
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteHsbcWithdrawDataRecordService {

    Long save(HsbcWithdrawDataRecordDto hsbcWithdrawDataRecordDto);


    HsbcWithdrawDataRecordDto getById(Long id);

    /**
     * 查询用户当前档位的已处理数量
     *
     * @param hsbcCurrentGearParam
     * @return
     */
    int queryConsumerCurrentGearCount(HsbcCurrentGearParam hsbcCurrentGearParam);

    /**
     * 查询用户最近一次的数据(已删除的也算)
     *
     * @param hsbcCurrentGearParam
     * @return
     */
    HsbcWithdrawDataRecordDto queryConsumerRecentlyAccount(HsbcCurrentGearParam hsbcCurrentGearParam);

    /**
     * 查询当天是否存在非某个用户的设备产生记录
     *
     * @param hsbcCurrentDeviceParam
     * @return
     */
    Boolean existOtherUseDeviceRecord(HsbcCurrentDeviceParam hsbcCurrentDeviceParam);

    /**
     * 查询当天是否存在非某个用户的账号充值数据产生记录
     *
     * @param hsbcCurrentAccountParam
     * @return
     */
    Boolean existOtherUseAccountRecord(HsbcCurrentAccountParam hsbcCurrentAccountParam);

//    /**
//     * 查询应用待操作的总金额
//     *
//     * @param appId
//     * @return
//     */
//    Long querySumAmountWithInitStatus(Long appId);

    /**
     * 校验是否命中总提现限制次数:true:命中限制;false:未命中
     *
     * @param hsbcTotalLimitParam
     * @return
     */
    Boolean checkLimitWithAllGearRecord(HsbcTotalLimitParam hsbcTotalLimitParam);


    /**
     * 乐观回滚，记录是初始状态才会回滚成功
     *
     * @param hsbcChangeStatusParam
     * @return
     */
    int rollbackById(HsbcChangeStatusParam hsbcChangeStatusParam);

    /**
     * 扣余额请求成功,乐观递进，记录是初始状态递进为扣余额请求成功
     *
     * @param hsbcChangeStatusParam
     * @return
     */
    int goPreWithdrawRequestSuccess(HsbcChangeStatusParam hsbcChangeStatusParam);

    /**
     * 回调结果,乐观递进，记录是扣余额请求成功递进为回调结果
     *
     * @param hsbcChangeStatusParam
     * @return
     */
    int goPreWithdrawResultSuccess(HsbcChangeStatusParam hsbcChangeStatusParam);

    /**
     * 兑吧业务失败,乐观递进，记录是回调成功递进为回调兑吧业务失败
     *
     * @param hsbcChangeStatusParam
     * @return
     */
    int goDuibaBizFail(HsbcChangeStatusParam hsbcChangeStatusParam);

    /**
     * 支付宝回调结果,乐观递进，记录是回调成功递进为支付宝回调结果
     *
     * @param hsbcChangeStatusParam
     * @return
     */
    int goAliCallbackResult(HsbcChangeStatusParam hsbcChangeStatusParam);

    /**
     * 查询需要回滚的数据，执行回滚
     * @param hsbcListRollbackParam
     * @return
     */
    List<HsbcWithdrawDataRecordDto> listRollbackByParam(HsbcListRollbackParam hsbcListRollbackParam);

    /**
     * 更新(仅包含提现ID、错误信息、第三方单号)
     * @param hsbcWithdrawDataRecordDto
     * @return
     */
    int updateById(HsbcWithdrawDataRecordDto hsbcWithdrawDataRecordDto);
}
