package cn.com.duiba.activity.custom.center.api.remoteservice.qqmusic;

import cn.com.duiba.activity.custom.center.api.dto.qqmusic.QQMusicRewardStatusDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by fangdong on 2019/09/09
 */
@AdvancedFeignClient
public interface RemoteQQMusicClearService {

    /**
     * 获取领奖信息
     * @param consumerId 用户id
     */
    Long getRewardStatus(Long consumerId, Integer type);

    /**
     * 批量获取领奖信息
     * @param consumerId 用户id
     */
    List<QQMusicRewardStatusDto> multiGetRewardStatus(Long consumerId, List<Integer> types);

    /**
     * 领奖操作记录
     * @param  action : 记录次数 1 ， 回滚次数 -1
     */
    void rewardNotify(Long consumerId, Integer type, Integer action);
}
