package cn.com.duiba.activity.custom.center.api.remoteservice.zzh;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * @author haojiahong
 * @date 2021-03-26
 */
@AdvancedFeignClient
public interface RemoteMonthLimitCreditsService {


    /**
     * 查询当月限额剩余数量
     *
     * @param appId
     * @param date
     * @param initCredits
     * @return
     */
    Integer queryRemain(Long appId, Date date, Integer initCredits);


    /**
     * 增加当月限额
     *
     * @param appId
     * @param date
     * @param credits
     * @return
     */
    Boolean incrRemain(Long appId, Date date, Integer credits);

    /**
     * 减少当月限额
     *
     * @param appId
     * @param date
     * @param credits
     * @return
     */
    Boolean decrRemain(Long appId, Date date, Integer credits);


}
