package cn.com.duiba.activity.custom.center.api.dto.hsbc;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/4/19 11:08 AM
 */
public class HsbcAppItemTagDto implements Serializable {

    public static final Integer SHOW_FOR_TAG = 0;

    public static final Integer EVERYDAY_STOCK_LIMIT = 1;

    private static final long serialVersionUID = -5610983607323341914L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * appId
     */
    private Long appId;

    /**
     * 客群标签
     */
    private String tagCode;

    /**
     * 客群标签权重
     */
    private Integer sort;

    /**
     * 标签开关，第0位：仅客群标签可见，第1位：可兑商品受每日库存限制
     */
    private Long tagSwitch;

    /**
     * 可见可兑商品ids，json格式
     */
    private String exchangeAppItemIds;

    /**
     * 可见不可兑商品ids，json格式
     */
    private String noExchangeAppItemIds;

    /**
     * 可见不可兑商品跳转链接
     */
    private String noExchangeAppItemUrl;

    /**
     * 可见不可兑按钮文案
     */
    private String noExchangeAppItemButtonText;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTagCode() {
        return tagCode;
    }

    public void setTagCode(String tagCode) {
        this.tagCode = tagCode;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Long getTagSwitch() {
        return tagSwitch;
    }

    public void setTagSwitch(Long tagSwitch) {
        this.tagSwitch = tagSwitch;
    }

    public String getExchangeAppItemIds() {
        return exchangeAppItemIds;
    }

    public void setExchangeAppItemIds(String exchangeAppItemIds) {
        this.exchangeAppItemIds = exchangeAppItemIds;
    }

    public String getNoExchangeAppItemIds() {
        return noExchangeAppItemIds;
    }

    public void setNoExchangeAppItemIds(String noExchangeAppItemIds) {
        this.noExchangeAppItemIds = noExchangeAppItemIds;
    }

    public String getNoExchangeAppItemUrl() {
        return noExchangeAppItemUrl;
    }

    public void setNoExchangeAppItemUrl(String noExchangeAppItemUrl) {
        this.noExchangeAppItemUrl = noExchangeAppItemUrl;
    }

    public String getNoExchangeAppItemButtonText() {
        return noExchangeAppItemButtonText;
    }

    public void setNoExchangeAppItemButtonText(String noExchangeAppItemButtonText) {
        this.noExchangeAppItemButtonText = noExchangeAppItemButtonText;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 判断开关是否打开
     * @param switchInt
     * @return
     */
    public boolean isSwitchOpen(int switchInt){
        int v = 1 << switchInt;
        long ret = tagSwitch & v;
        return ret != 0;
    }

    /**
     * 关闭开关
     * @param type
     */
    public void disableSwitch(Integer type) {
        int v = 1 << type;
        v = ~v;
        tagSwitch = tagSwitch & v;
    }

    /**
     * 开启开关
     * @param type
     */
    public void enableSwitch(Integer type) {
        int v = 1 << type;
        tagSwitch = tagSwitch | v;
    }
}
