package cn.com.duiba.activity.custom.center.api.enums.identity;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/8/19 上午10:29
 */
public enum  IdentityNewRelTypeEnum {
    /**
     * app_id=-1L:所有app通用
     * rel_type=-1:为当前app_id定制有效
     * app_id + rel_type为key
     */

    // 通用rel_type
    MOBILE(-1L,1,"手机号码"),

    // 特殊定制
    // rel_type 代表每次导入期次
    WHITE_LIST(82461L,-1,"太原中信-地铁活动白名单"),

    // 唯一对应
    BETAID(77780L,2,"宁波银行定制dcustom参数"),
    EQUITY_ORDER(70784L,2,"青海中行-商户权益核销记录关联订单id"),
    OPENID_AND_UNIONID(82066L,2,"山东银联定制-openId和unionId映射关系"),
    BLIND_BOX(19592L,2,"智己汽车-用户与盲盒关联"),
    //由于1已经被人使用，所以浙江银联用2来保存手机号
    ZJUNION_MOBILE(90195L,2,"浙江银联-用户绑定手机号"),
    CITIC_EXCHANGE(85545L,2,"中信-普兑"),
    CITIC_SEC(85545L,3,"中信-秒杀"),
    FUJIAN_OPENID(80166L,2,"福建中行-用户绑定手机号关联表"),
    FUJIAN_TASK_ENTER(80166L,3,"福建中行-用户每月任务进入时时间戳记录"),
    // 记录隐私勾选状态
    CHECK_PRIVACY(-1L,9,"勾选隐私"),
    LIAONING_ABC(87642L,2,"辽宁农行-双端打通，custId作为uid，relContent放微信openId"),
    LIAONING_PHONE(87642L,3,"辽宁农行-双端打通，uid为openId，relContent放用户绑定手机号"),
    BJHYUNDAI_HISTORY_RECORE(72596L,4, "北京现代-搜索组件历史记录"),
    GUANGDONG_UNION_PAY_OPEN_ID(84339L,2, "广东银联粤积分用户修改信息通知，relContent放微信openId"),
    GUANGDONG_ICBC_BIND(80196L,1, "广东工行双端用户信息绑定"),
    SHPF_BANK_APP_ITEM_CLASSIFY(89652L,2, "上海浦发银行商品分组兑换限制"),
    GZNS_BANK_OPENID_ENCPHONE(86364L,1, "广州农商行-双端打通 uid为openId, relConent为加密手机号"),
    ORDER_WXCOUPON(-1L,10, "订单id与微信立减金id绑定"),
    CCB_WXCOUPON(89897L,10, "建行三方订单号和活动编号绑定"),
    FUJIAN_BOC_PUSH_FAIL_EXCHANGE(80166L,11, "福建中行推送失败记录"),
    QINGDAO_WHITE_GROUP(67707L,11, "青岛银行定制白名单功能"),
    HSBC_CXA_APPITEM(-1L,11,"汇丰汇选cxa商品"),
    ZJ_UNION_NFT(90005L,12,"浙江银联数字藏品绑定订单号"),
    ;


    private Long appId;
    private Integer relType;
    private String desc;

    IdentityNewRelTypeEnum(Long appId, Integer relType, String desc) {
        this.appId = appId;
        this.relType = relType;
        this.desc = desc;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getRelType() {
        return relType;
    }

    public void setRelType(Integer relType) {
        this.relType = relType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
