package cn.com.duiba.activity.custom.center.api.dto.hsbc;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/10/9 16
 * @Description:
 */
public class HsbcWithdrawDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 发奖规则
     */
    private String rule;

    /**
     * 档位标识
     */
    private List<GearConfig> gearConfigList;

    /**
     * 总提现限制次数(根据总提现限制次数类型)
     */
    private Integer totalLimitCount;

    /**
     * 总提现限制次数类型:1:每日;2:永久
     */
    private Integer totalLimitCountType;

    /**
     * 单用户提现预算(每日总)
     */
    private Long consumerLimitAmount;

    /**
     * 提现预算(每日总)
     */
    private Long limitAmount;

    /**
     * 预算预警值(每日总)
     */
    private Long warnAmount;

    /**
     * 预警手机号
     */
    private String warnPhone;

    /**
     * 时间段预算
     */
    private List<LimitTimeBudget> limitTimeBudget;

    private List<TagWithdraw> tagWithdrawConfig;

    public List<TagWithdraw> getTagWithdrawConfig() {
        return tagWithdrawConfig;
    }

    public void setTagWithdrawConfig(List<TagWithdraw> tagWithdrawConfig) {
        this.tagWithdrawConfig = tagWithdrawConfig;
    }

    public List<LimitTimeBudget> getLimitTimeBudget() {
        return limitTimeBudget;
    }

    public void setLimitTimeBudget(List<LimitTimeBudget> limitTimeBudget) {
        this.limitTimeBudget = limitTimeBudget;
    }

    /**
     * 白名单开关
     */
    private Boolean whiteListFlag = false;

    /**
     * 白名单提现预算
     */
    private Long whiteWithdrawBudget;

    /**
     * 提现时间开始
     */
    private Long withdrawTimeStart;

    /**
     * 提现时间结束
     */
    private Long withdrawTimeEnd;

    /**
     * 用户限制
     */
    private List<UserLimitConfig> userLimitConfigList;

    public List<UserLimitConfig> getUserLimitConfigList() {
        return userLimitConfigList;
    }

    public void setUserLimitConfigList(List<UserLimitConfig> userLimitConfigList) {
        this.userLimitConfigList = userLimitConfigList;
    }

    public Boolean getWhiteListFlag() {
        return whiteListFlag;
    }

    public void setWhiteListFlag(Boolean whiteListFlag) {
        this.whiteListFlag = whiteListFlag;
    }

    public Long getWhiteWithdrawBudget() {
        return whiteWithdrawBudget;
    }

    public void setWhiteWithdrawBudget(Long whiteWithdrawBudget) {
        this.whiteWithdrawBudget = whiteWithdrawBudget;
    }

    public Long getWithdrawTimeStart() {
        return withdrawTimeStart;
    }

    public void setWithdrawTimeStart(Long withdrawTimeStart) {
        this.withdrawTimeStart = withdrawTimeStart;
    }

    public Long getWithdrawTimeEnd() {
        return withdrawTimeEnd;
    }

    public void setWithdrawTimeEnd(Long withdrawTimeEnd) {
        this.withdrawTimeEnd = withdrawTimeEnd;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public List<GearConfig> getGearConfigList() {
        return gearConfigList;
    }

    public void setGearConfigList(List<GearConfig> gearConfigList) {
        this.gearConfigList = gearConfigList;
    }

    public Integer getTotalLimitCount() {
        return totalLimitCount;
    }

    public void setTotalLimitCount(Integer totalLimitCount) {
        this.totalLimitCount = totalLimitCount;
    }

    public Integer getTotalLimitCountType() {
        return totalLimitCountType;
    }

    public void setTotalLimitCountType(Integer totalLimitCountType) {
        this.totalLimitCountType = totalLimitCountType;
    }

    public Long getConsumerLimitAmount() {
        return consumerLimitAmount;
    }

    public void setConsumerLimitAmount(Long consumerLimitAmount) {
        this.consumerLimitAmount = consumerLimitAmount;
    }

    public Long getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Long limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Long getWarnAmount() {
        return warnAmount;
    }

    public void setWarnAmount(Long warnAmount) {
        this.warnAmount = warnAmount;
    }

    public String getWarnPhone() {
        return warnPhone;
    }

    public void setWarnPhone(String warnPhone) {
        this.warnPhone = warnPhone;
    }

    public static class GearConfig implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 档位唯一标识
         */
        private String gearUniqueKey;

        /**
         * 排序,数值越小优先级越高，最小的代表一档
         */
        private Integer sort;

        /**
         * 金额:分
         */
        @NotNull(message = "金额不可为空")
        private Long amount;

        /**
         * 限制次数
         */
        private Long gearLimitCount;

        /**
         * 类型:1:每日;2:永久
         */
        @NotNull(message = "档位类型不可为空")
        private Integer type;

        /**
         * 限制变更的时间戳(所属标识的类型、金额变更时，后端主动变更时间)
         */
        private Long limitChangeTimeStamp;

        /**
         * 每日，档位预算
         */
        private Long gearBudget;

        /**
         * 客群标签开关
         */
        private boolean tagSwitch;

        /**
         * 客群标签
         */
        private List<Tag> tagList;

        public Long getGearBudget() {
            return gearBudget;
        }

        public void setGearBudget(Long gearBudget) {
            this.gearBudget = gearBudget;
        }

        public Long getGearLimitCount() {
            return gearLimitCount;
        }

        public void setGearLimitCount(Long gearLimitCount) {
            this.gearLimitCount = gearLimitCount;
        }

        public String getGearUniqueKey() {
            return gearUniqueKey;
        }

        public void setGearUniqueKey(String gearUniqueKey) {
            this.gearUniqueKey = gearUniqueKey;
        }

        public Integer getSort() {
            return sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public Long getAmount() {
            return amount;
        }

        public void setAmount(Long amount) {
            this.amount = amount;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Long getLimitChangeTimeStamp() {
            return limitChangeTimeStamp;
        }

        public void setLimitChangeTimeStamp(Long limitChangeTimeStamp) {
            this.limitChangeTimeStamp = limitChangeTimeStamp;
        }

        public boolean isTagSwitch() {
            return tagSwitch;
        }

        public void setTagSwitch(boolean tagSwitch) {
            this.tagSwitch = tagSwitch;
        }

        public List<Tag> getTagList() {
            return tagList;
        }

        public void setTagList(List<Tag> tagList) {
            this.tagList = tagList;
        }
    }

    public static class LimitTimeBudget implements Serializable {

        private static final long serialVersionUID = -8673807513379127505L;
        /**
         * 时间段唯一标识
         */
        private String timeUniqueKey;

        /**
         * 限制时间段：["08:50", "15:50"]
         */
        private List<String> limitTime;

        /**
         * 时间段内预算
         */
        private Long timeBudget;

        /**
         * 限制变更的时间戳(所属标识的类型、金额变更时，后端主动变更时间)
         */
        private Long limitChangeTimeStamp;

        public String getTimeUniqueKey() {
            return timeUniqueKey;
        }

        public void setTimeUniqueKey(String timeUniqueKey) {
            this.timeUniqueKey = timeUniqueKey;
        }

        public List<String> getLimitTime() {
            return limitTime;
        }

        public void setLimitTime(List<String> limitTime) {
            this.limitTime = limitTime;
        }

        public Long getTimeBudget() {
            return timeBudget;
        }

        public void setTimeBudget(Long timeBudget) {
            this.timeBudget = timeBudget;
        }

        public Long getLimitChangeTimeStamp() {
            return limitChangeTimeStamp;
        }

        public void setLimitChangeTimeStamp(Long limitChangeTimeStamp) {
            this.limitChangeTimeStamp = limitChangeTimeStamp;
        }
    }

    public static class TagWithdraw implements Serializable {

        private static final long serialVersionUID = 5450976907759948327L;
        /**
         * 客群标签code
         */
        private String tagCode;

        /**
         * 客群标签名
         */
        private String tagName;

        /**
         * 标签生效开始时间
         */
        private Long startTime;

        /**
         * 标签失效结束时间
         */
        private Long endTime;

        /**
         * 权重
         */
        private Integer sort;

        /**
         * 单用户提现限制次数
         */
        private Integer totalLimitCount;

        /**
         * 提现限制次数类型:1:每日;2:永久
         */
        private Integer totalLimitCountType;

        /**
         * 单用户提现预算:分
         */
        private Long consumerLimitAmount;

        /**
         * 提现预算:分
         */
        private Long limitAmount;

        /**
         * 预算预警值
         */
        private Long warnAmount;

        /**
         * 预警手机号
         */
        private String warnPhone;

        public String getTagCode() {
            return tagCode;
        }

        public void setTagCode(String tagCode) {
            this.tagCode = tagCode;
        }

        public String getTagName() {
            return tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public Long getStartTime() {
            return startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public Integer getSort() {
            return sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public Integer getTotalLimitCount() {
            return totalLimitCount;
        }

        public void setTotalLimitCount(Integer totalLimitCount) {
            this.totalLimitCount = totalLimitCount;
        }

        public Integer getTotalLimitCountType() {
            return totalLimitCountType;
        }

        public void setTotalLimitCountType(Integer totalLimitCountType) {
            this.totalLimitCountType = totalLimitCountType;
        }

        public Long getConsumerLimitAmount() {
            return consumerLimitAmount;
        }

        public void setConsumerLimitAmount(Long consumerLimitAmount) {
            this.consumerLimitAmount = consumerLimitAmount;
        }

        public Long getLimitAmount() {
            return limitAmount;
        }

        public void setLimitAmount(Long limitAmount) {
            this.limitAmount = limitAmount;
        }

        public Long getWarnAmount() {
            return warnAmount;
        }

        public void setWarnAmount(Long warnAmount) {
            this.warnAmount = warnAmount;
        }

        public String getWarnPhone() {
            return warnPhone;
        }

        public void setWarnPhone(String warnPhone) {
            this.warnPhone = warnPhone;
        }
    }

    public static class Tag implements Serializable {

        private static final long serialVersionUID = 3349035103494514192L;

        /**
         * 客群标签code
         */
        private String tagCode;

        /**
         * 客群标签名
         */
        private String tagName;

        public String getTagCode() {
            return tagCode;
        }

        public void setTagCode(String tagCode) {
            this.tagCode = tagCode;
        }

        public String getTagName() {
            return tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }
    }

}

