package cn.com.duiba.activity.custom.center.api.dto.pinganshengqian;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 平安福利订单
 * @Author huliangsheng
 * @Date 2025/4/28 19:08
 */
public class PingAnFlOrderDto implements Serializable {

    private static final long serialVersionUID = -1847222983372536691L;

    /**
     * 订单号
     */
    private String id;

    /**
     * 用户唯一Id
     */
    private String openUserId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 商品标题（订单内所有商品标题缩写）
     */
    private String goodsNames;

    /**
     * goodsImages
     */
    private List<String> goodsImages;

    /**
     * 订单状态 (0-待支付 2-处理中 3-已完成 7-已退款 8-已取消 10-出餐中 20-出餐成功 40-配送中)
     */
    private Integer status;

    /**
     * 订单总价（单位分）
     */
    private Integer actualAmount;

    /**
     * 订单商品总价（单位分），不含配送费
     */
    private Integer totalSalesPrice;

    /**
     * 成本价（单位分）
     */
    private Integer costPrice;

    /**
     * placeTime
     */
    private String placeTime;

    /**
     * paymentStatus
     */
    private Integer paymentStatus;

    /**
     * paymentTime
     */
    private String paymentTime;

    /**
     * 取餐方式 (0-堂食 1-打包 2-外送)
     */
    private Integer packFlag;

    /**
     * deliveryStatus
     */
    private Integer deliveryStatus;

    /**
     * 收货人手机号
     */
    private String receiverPhone;

    /**
     * 收货人
     */
    private String receiverName;

    /**
     * 收货地址
     */
    private String receiverAddress;

    /**
     * 配送费（单位分）
     */
    private Integer deliveryPrice;

    /**
     * remarks
     */
    private String remarks;

    /**
     * 取餐码
     */
    private String takeCode;

    /**
     * 取餐二维码 (不一定有, 需自行将字符串转换为二维码)
     */
    private String qrData;

    /**
     * 订单商品详情
     */
    private List<FlOrderDetail> orderDetails;


    public Integer getActualAmount() {
        return actualAmount;
    }

    public void setActualAmount(Integer actualAmount) {
        this.actualAmount = actualAmount;
    }

    public Integer getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(Integer costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getDeliveryPrice() {
        return deliveryPrice;
    }

    public void setDeliveryPrice(Integer deliveryPrice) {
        this.deliveryPrice = deliveryPrice;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public List<String> getGoodsImages() {
        return goodsImages;
    }

    public void setGoodsImages(List<String> goodsImages) {
        this.goodsImages = goodsImages;
    }

    public String getGoodsNames() {
        return goodsNames;
    }

    public void setGoodsNames(String goodsNames) {
        this.goodsNames = goodsNames;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOpenUserId() {
        return openUserId;
    }

    public void setOpenUserId(String openUserId) {
        this.openUserId = openUserId;
    }

    public List<FlOrderDetail> getOrderDetails() {
        return orderDetails;
    }

    public void setOrderDetails(List<FlOrderDetail> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public Integer getPackFlag() {
        return packFlag;
    }

    public void setPackFlag(Integer packFlag) {
        this.packFlag = packFlag;
    }

    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(String paymentTime) {
        this.paymentTime = paymentTime;
    }

    public String getPlaceTime() {
        return placeTime;
    }

    public void setPlaceTime(String placeTime) {
        this.placeTime = placeTime;
    }

    public String getQrData() {
        return qrData;
    }

    public void setQrData(String qrData) {
        this.qrData = qrData;
    }

    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getTakeCode() {
        return takeCode;
    }

    public void setTakeCode(String takeCode) {
        this.takeCode = takeCode;
    }

    public Integer getTotalSalesPrice() {
        return totalSalesPrice;
    }

    public void setTotalSalesPrice(Integer totalSalesPrice) {
        this.totalSalesPrice = totalSalesPrice;
    }
}
