package cn.com.duiba.activity.custom.center.api.enums.hsbc;

/**
 * @Author: fss
 * @Date: 2022/10/11 19
 * @Description:
 */
public enum HsbcWithdrawApplyEnum {

    /**
     * 3、4、6、7、8 是终态
     */
    INIT(1, "初始状态"),
    REQUEST_SUCCESS(2, "扣余额请求成功"),
    ROLLBACK(3, "回滚"),
    CALLBACK_FAIL(4, "回调失败"),
    CALLBACK_SUCCESS(5, "回调成功"),
    CALLBACK_SUCCESS_BIZ_FAIL(6, "回调成功兑吧业务失败"),
    ALI_SUCCESS(7, "支付宝回调成功"),
    ALI_FAIL(8, "支付宝回调失败"),
    ;

    Integer status;
    String desc;

    HsbcWithdrawApplyEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static HsbcWithdrawApplyEnum valueOfType(Integer type) {
        for (HsbcWithdrawApplyEnum obj : HsbcWithdrawApplyEnum.values()) {
            if (java.util.Objects.equals(obj.status, type)) {
                return obj;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
