package cn.com.duiba.activity.custom.center.api.enums.qingdao.qdccb.task;

import org.apache.commons.lang3.StringUtils;

/**
 * @author haojiahong
 * @date 2022-12-23
 */
public enum TaskTypeEnums {

    STAR_JAN("STAR_JAN", "明星任务-一月", "一月明星任务"),
    STAR_FEB("STAR_FEB", "明星任务-二月", "二月明星任务"),
    STAR_MAR("STAR_MAR", "明星任务-三月", "三月明星任务"),
    STAR_APR("STAR_APR", "明星任务-四月", "四月明星任务"),
    STAR_MAY("STAR_MAY", "明星任务-五月", "五月明星任务"),
    STAR_JUN("STAR_JUN", "明星任务-六月", "六月明星任务"),
    STAR_JUL("STAR_JUL", "明星任务-七月", "七月明星任务"),
    STAR_AUG("STAR_AUG", "明星任务-八月", "八月明星任务"),
    STAR_SEPT("STAR_SEPT", "明星任务-九月", "九月明星任务"),
    STAR_OCT("STAR_OCT", "明星任务-十月", "十月明星任务"),
    STAR_NOV("STAR_NOV", "明星任务-十一月", "十一月明星任务"),
    STAR_DEC("STAR_DEC", "明星任务-十二月", "十二月明星任务"),

    PER_DAY_SIGN("PER_DAY_SIGN", "每日任务-签到任务", ""),
    PER_DAY_SHARE("PER_DAY_SHARE", "每日任务-分享任务", ""),

    BASE_FIRST_LOGIN("BASE_FIRST_LOGIN", "基础任务-首次进入青银社", "首次进入青银社"),
    BASE_WX_PAY("BASE_WX_PAY", "基础任务-签约微信支付", "签约微信支付"),
    BASE_ALI_PAY("BASE_ALI_PAY", "基础任务-签约支付宝支付", "签约支付宝支付"),
    BASE_WX_BIND("BASE_WX_BIND", "基础任务-首绑微信银行", "首绑微信银行"),

    PER_MONTH_LOGIN("PER_MONTH_LOGIN", "月度任务-登录任务", ""),
    PER_MONTH_VIEW("PER_MONTH_VIEW", "月度任务-浏览任务", ""),
    PER_MONTH_OTHER("PER_MONTH_OTHER", "月度任务-其他任务", ""),
    ;


    private String type;
    private String desc;
    private String showText;

    TaskTypeEnums(String type, String desc, String showText) {
        this.type = type;
        this.desc = desc;
        this.showText = showText;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getShowText() {
        return showText;
    }

    public static TaskTypeEnums getByType(String type) {
        for (TaskTypeEnums value : TaskTypeEnums.values()) {
            if (StringUtils.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }
}
