package cn.com.duiba.activity.custom.center.api.params.pinganshengqian;

import cn.com.duiba.api.bo.page.PageQuery;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单记录查询参数
 * @Author huliangsheng
 * @Date 2024/11/22 18:44
 */
public class OrderRecordQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -7804750224517602645L;

    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空")
    private String partnerUserId;

    /**
     * 渠道
     * 0-自有商品 1-三方渠道
     */
    private List<String> channel;

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public List<String> getChannel() {
        return channel;
    }

    public void setChannel(List<String> channel) {
        this.channel = channel;
    }
}
