package cn.com.duiba.activity.custom.center.api.remoteservice.xiangshang;

import cn.com.duiba.activity.custom.center.api.dto.xiangshang.XiangShangRecordDto;
import cn.com.duiba.activity.custom.center.api.dto.xiangshang.XiangShangRecordListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/4/25 上午11:29
 */
@AdvancedFeignClient
public interface RemoteXiangShangRecordService {

    /**
     * 条件查询直充记录分页
     * @param param
     * @return
     */
    Page<XiangShangRecordDto> pageByCondition(XiangShangRecordListParam param);

    /**
     * 保存向上话费直充记录
     * @param dto
     * @return
     */
    int save(XiangShangRecordDto dto);

    /**
     * 批量保存记录
     * @param dtoList
     * @return
     */
    int batchSave(List<XiangShangRecordDto> dtoList);

    /**
     * 根据订单号查询直充记录
     * @param orderNum
     * @return
     */
    XiangShangRecordDto selectByOrderNum(String orderNum);

    /**
     * 根据订单号修改直充状态
     * @param orderNum
     * @param status
     * @return
     */
    int updateStatusByOrderNum(String orderNum, Integer status);

    /**
     * 根据订单号修改记录
     * @param dto
     * @return
     */
    int updateByOrderNum(XiangShangRecordDto dto);
}
