package cn.com.duiba.activity.custom.center.api.remoteservice.pinganshengqian;

import cn.com.duiba.activity.custom.center.api.dto.jxgh.PageList;
import cn.com.duiba.activity.custom.center.api.dto.pinganshengqian.PingAnShengQianDeductionDto;
import cn.com.duiba.activity.custom.center.api.dto.pinganshengqian.PingAnShengQianOrderDto;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.OrderRecordQueryParam;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.PingAnOrderParam;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.PingAnQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @Description 平安保险省钱小程序，订单记录remote
 * @Author huliangsheng
 * @Date 2024/11/22 15:29
 */
@AdvancedFeignClient
public interface RemotePingAnOrderService {

    /**
     * 新增一条订单记录
     */
    Boolean insertRecord(PingAnOrderParam param);

    /**
     * 修改订单记录
     */
    Boolean updateRecord(PingAnOrderParam param);

    /**
     * 查询订单记录列表
     */
    PageList<PingAnShengQianDeductionDto> pageQueryOrderListByType(OrderRecordQueryParam param);

    /**
     * 根据支付单号查询指定抵扣记录
     *
     * @param payOrderNum 支付单号
     * @return 抵扣记录
     */
    PingAnShengQianDeductionDto queryByPayOrderNum(String payOrderNum);

    /**
     * 根据渠道和订单号查询抵扣记录
     *
     * @param channel  渠道
     * @param orderNum 订单号
     * @return 抵扣记录
     */
    PingAnShengQianDeductionDto queryByOrderNum(String channel, String orderNum);

    /**
     * 查询指定抵扣记录总数
     */
    int countOrderList(PingAnQueryParam param);

    /**
     * 查询待支付的订单
     */
    PageList<PingAnShengQianDeductionDto> queryPendingPaymentOrder(PingAnQueryParam param);

}
