package cn.com.duiba.activity.custom.center.api.remoteservice.coupon;

import cn.com.duiba.activity.custom.center.api.dto.coupon.CouponVerificationDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/6/24 09:58
 */
@AdvancedFeignClient
public interface RemoteCouponVerificationService {
    /**
     * 保存优惠券核销信息
     * @param dto
     * @return
     * @throws BizException
     */
    Long save(CouponVerificationDto dto) throws BizException;

    /**
     * 批量获取优惠券核销信息
     *
     * 若consumerId为空，请确保券码唯一
     * @param couponCodes 券码
     * @param appId 应用ID
     * @return
     */
    List<CouponVerificationDto> getCouponCodeList(List<String> couponCodes, Long appId);

    /**
     * 获取优惠券核销信息
     * @param couponCode
     * @param appId
     * @return
     */
    CouponVerificationDto getCouponVerificationInfo(String couponCode, Long appId);
}
