// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/type/http_request.proto

package my.com.google.logging.type;

/**
 * <pre>
 * A common proto for logging HTTP requests. Only contains semantics
 * defined by the HTTP specification. Product-specific logging
 * information MUST be defined in a separate message.
 * </pre>
 *
 * Protobuf type {@code google.logging.type.HttpRequest}
 */
public  final class HttpRequest extends
    my.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.logging.type.HttpRequest)
    HttpRequestOrBuilder {
  // Use HttpRequest.newBuilder() to construct.
  private HttpRequest(my.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HttpRequest() {
    requestMethod_ = "";
    requestUrl_ = "";
    requestSize_ = 0L;
    status_ = 0;
    responseSize_ = 0L;
    userAgent_ = "";
    remoteIp_ = "";
    serverIp_ = "";
    referer_ = "";
    cacheLookup_ = false;
    cacheHit_ = false;
    cacheValidatedWithOriginServer_ = false;
    cacheFillBytes_ = 0L;
  }

  @java.lang.Override
  public final my.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return my.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private HttpRequest(
      my.com.google.protobuf.CodedInputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            requestMethod_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            requestUrl_ = s;
            break;
          }
          case 24: {

            requestSize_ = input.readInt64();
            break;
          }
          case 32: {

            status_ = input.readInt32();
            break;
          }
          case 40: {

            responseSize_ = input.readInt64();
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            userAgent_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();

            remoteIp_ = s;
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();

            referer_ = s;
            break;
          }
          case 72: {

            cacheHit_ = input.readBool();
            break;
          }
          case 80: {

            cacheValidatedWithOriginServer_ = input.readBool();
            break;
          }
          case 88: {

            cacheLookup_ = input.readBool();
            break;
          }
          case 96: {

            cacheFillBytes_ = input.readInt64();
            break;
          }
          case 106: {
            java.lang.String s = input.readStringRequireUtf8();

            serverIp_ = s;
            break;
          }
          case 114: {
            my.com.google.protobuf.Duration.Builder subBuilder = null;
            if (latency_ != null) {
              subBuilder = latency_.toBuilder();
            }
            latency_ = input.readMessage(my.com.google.protobuf.Duration.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(latency_);
              latency_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new my.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      makeExtensionsImmutable();
    }
  }
  public static final my.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return my.com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
  }

  protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return my.com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            my.com.google.logging.type.HttpRequest.class, my.com.google.logging.type.HttpRequest.Builder.class);
  }

  public static final int REQUEST_METHOD_FIELD_NUMBER = 1;
  private volatile java.lang.Object requestMethod_;
  /**
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   */
  public java.lang.String getRequestMethod() {
    java.lang.Object ref = requestMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestMethod_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   */
  public my.com.google.protobuf.ByteString
      getRequestMethodBytes() {
    java.lang.Object ref = requestMethod_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      requestMethod_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_URL_FIELD_NUMBER = 2;
  private volatile java.lang.Object requestUrl_;
  /**
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   */
  public java.lang.String getRequestUrl() {
    java.lang.Object ref = requestUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestUrl_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   */
  public my.com.google.protobuf.ByteString
      getRequestUrlBytes() {
    java.lang.Object ref = requestUrl_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      requestUrl_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_SIZE_FIELD_NUMBER = 3;
  private long requestSize_;
  /**
   * <pre>
   * The size of the HTTP request message in bytes, including the request
   * headers and the request body.
   * </pre>
   *
   * <code>int64 request_size = 3;</code>
   */
  public long getRequestSize() {
    return requestSize_;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_;
  /**
   * <pre>
   * The response code indicating the status of response.
   * Examples: 200, 404.
   * </pre>
   *
   * <code>int32 status = 4;</code>
   */
  public int getStatus() {
    return status_;
  }

  public static final int RESPONSE_SIZE_FIELD_NUMBER = 5;
  private long responseSize_;
  /**
   * <pre>
   * The size of the HTTP response message sent back to the client, in bytes,
   * including the response headers and the response body.
   * </pre>
   *
   * <code>int64 response_size = 5;</code>
   */
  public long getResponseSize() {
    return responseSize_;
  }

  public static final int USER_AGENT_FIELD_NUMBER = 6;
  private volatile java.lang.Object userAgent_;
  /**
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   */
  public java.lang.String getUserAgent() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userAgent_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   */
  public my.com.google.protobuf.ByteString
      getUserAgentBytes() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      userAgent_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_IP_FIELD_NUMBER = 7;
  private volatile java.lang.Object remoteIp_;
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   */
  public java.lang.String getRemoteIp() {
    java.lang.Object ref = remoteIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteIp_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   */
  public my.com.google.protobuf.ByteString
      getRemoteIpBytes() {
    java.lang.Object ref = remoteIp_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      remoteIp_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_IP_FIELD_NUMBER = 13;
  private volatile java.lang.Object serverIp_;
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   */
  public java.lang.String getServerIp() {
    java.lang.Object ref = serverIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serverIp_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   */
  public my.com.google.protobuf.ByteString
      getServerIpBytes() {
    java.lang.Object ref = serverIp_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      serverIp_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERER_FIELD_NUMBER = 8;
  private volatile java.lang.Object referer_;
  /**
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
   * </pre>
   *
   * <code>string referer = 8;</code>
   */
  public java.lang.String getReferer() {
    java.lang.Object ref = referer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      my.com.google.protobuf.ByteString bs =
          (my.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
   * </pre>
   *
   * <code>string referer = 8;</code>
   */
  public my.com.google.protobuf.ByteString
      getRefererBytes() {
    java.lang.Object ref = referer_;
    if (ref instanceof java.lang.String) {
      my.com.google.protobuf.ByteString b =
          my.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referer_ = b;
      return b;
    } else {
      return (my.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATENCY_FIELD_NUMBER = 14;
  private my.com.google.protobuf.Duration latency_;
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public boolean hasLatency() {
    return latency_ != null;
  }
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public my.com.google.protobuf.Duration getLatency() {
    return latency_ == null ? my.com.google.protobuf.Duration.getDefaultInstance() : latency_;
  }
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public my.com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
    return getLatency();
  }

  public static final int CACHE_LOOKUP_FIELD_NUMBER = 11;
  private boolean cacheLookup_;
  /**
   * <pre>
   * Whether or not a cache lookup was attempted.
   * </pre>
   *
   * <code>bool cache_lookup = 11;</code>
   */
  public boolean getCacheLookup() {
    return cacheLookup_;
  }

  public static final int CACHE_HIT_FIELD_NUMBER = 9;
  private boolean cacheHit_;
  /**
   * <pre>
   * Whether or not an entity was served from cache
   * (with or without validation).
   * </pre>
   *
   * <code>bool cache_hit = 9;</code>
   */
  public boolean getCacheHit() {
    return cacheHit_;
  }

  public static final int CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER = 10;
  private boolean cacheValidatedWithOriginServer_;
  /**
   * <pre>
   * Whether or not the response was validated with the origin server before
   * being served from cache. This field is only meaningful if `cache_hit` is
   * True.
   * </pre>
   *
   * <code>bool cache_validated_with_origin_server = 10;</code>
   */
  public boolean getCacheValidatedWithOriginServer() {
    return cacheValidatedWithOriginServer_;
  }

  public static final int CACHE_FILL_BYTES_FIELD_NUMBER = 12;
  private long cacheFillBytes_;
  /**
   * <pre>
   * The number of HTTP response bytes inserted into cache. Set only when a
   * cache fill was attempted.
   * </pre>
   *
   * <code>int64 cache_fill_bytes = 12;</code>
   */
  public long getCacheFillBytes() {
    return cacheFillBytes_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(my.com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getRequestMethodBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requestMethod_);
    }
    if (!getRequestUrlBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      output.writeInt64(3, requestSize_);
    }
    if (status_ != 0) {
      output.writeInt32(4, status_);
    }
    if (responseSize_ != 0L) {
      output.writeInt64(5, responseSize_);
    }
    if (!getUserAgentBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 6, userAgent_);
    }
    if (!getRemoteIpBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 7, remoteIp_);
    }
    if (!getRefererBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 8, referer_);
    }
    if (cacheHit_ != false) {
      output.writeBool(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      output.writeBool(10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      output.writeBool(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      output.writeInt64(12, cacheFillBytes_);
    }
    if (!getServerIpBytes().isEmpty()) {
      my.com.google.protobuf.GeneratedMessageV3.writeString(output, 13, serverIp_);
    }
    if (latency_ != null) {
      output.writeMessage(14, getLatency());
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getRequestMethodBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requestMethod_);
    }
    if (!getRequestUrlBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, requestSize_);
    }
    if (status_ != 0) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeInt32Size(4, status_);
    }
    if (responseSize_ != 0L) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeInt64Size(5, responseSize_);
    }
    if (!getUserAgentBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(6, userAgent_);
    }
    if (!getRemoteIpBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(7, remoteIp_);
    }
    if (!getRefererBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(8, referer_);
    }
    if (cacheHit_ != false) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeBoolSize(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeBoolSize(10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeBoolSize(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeInt64Size(12, cacheFillBytes_);
    }
    if (!getServerIpBytes().isEmpty()) {
      size += my.com.google.protobuf.GeneratedMessageV3.computeStringSize(13, serverIp_);
    }
    if (latency_ != null) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeMessageSize(14, getLatency());
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof my.com.google.logging.type.HttpRequest)) {
      return super.equals(obj);
    }
    my.com.google.logging.type.HttpRequest other = (my.com.google.logging.type.HttpRequest) obj;

    boolean result = true;
    result = result && getRequestMethod()
        .equals(other.getRequestMethod());
    result = result && getRequestUrl()
        .equals(other.getRequestUrl());
    result = result && (getRequestSize()
        == other.getRequestSize());
    result = result && (getStatus()
        == other.getStatus());
    result = result && (getResponseSize()
        == other.getResponseSize());
    result = result && getUserAgent()
        .equals(other.getUserAgent());
    result = result && getRemoteIp()
        .equals(other.getRemoteIp());
    result = result && getServerIp()
        .equals(other.getServerIp());
    result = result && getReferer()
        .equals(other.getReferer());
    result = result && (hasLatency() == other.hasLatency());
    if (hasLatency()) {
      result = result && getLatency()
          .equals(other.getLatency());
    }
    result = result && (getCacheLookup()
        == other.getCacheLookup());
    result = result && (getCacheHit()
        == other.getCacheHit());
    result = result && (getCacheValidatedWithOriginServer()
        == other.getCacheValidatedWithOriginServer());
    result = result && (getCacheFillBytes()
        == other.getCacheFillBytes());
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REQUEST_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getRequestMethod().hashCode();
    hash = (37 * hash) + REQUEST_URL_FIELD_NUMBER;
    hash = (53 * hash) + getRequestUrl().hashCode();
    hash = (37 * hash) + REQUEST_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        getRequestSize());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getStatus();
    hash = (37 * hash) + RESPONSE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        getResponseSize());
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgent().hashCode();
    hash = (37 * hash) + REMOTE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteIp().hashCode();
    hash = (37 * hash) + SERVER_IP_FIELD_NUMBER;
    hash = (53 * hash) + getServerIp().hashCode();
    hash = (37 * hash) + REFERER_FIELD_NUMBER;
    hash = (53 * hash) + getReferer().hashCode();
    if (hasLatency()) {
      hash = (37 * hash) + LATENCY_FIELD_NUMBER;
      hash = (53 * hash) + getLatency().hashCode();
    }
    hash = (37 * hash) + CACHE_LOOKUP_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashBoolean(
        getCacheLookup());
    hash = (37 * hash) + CACHE_HIT_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashBoolean(
        getCacheHit());
    hash = (37 * hash) + CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashBoolean(
        getCacheValidatedWithOriginServer());
    hash = (37 * hash) + CACHE_FILL_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        getCacheFillBytes());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static my.com.google.logging.type.HttpRequest parseFrom(
      my.com.google.protobuf.ByteString data)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(
      my.com.google.protobuf.ByteString data,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(byte[] data)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(
      byte[] data,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(
      java.io.InputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static my.com.google.logging.type.HttpRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static my.com.google.logging.type.HttpRequest parseDelimitedFrom(
      java.io.InputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(
      my.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static my.com.google.logging.type.HttpRequest parseFrom(
      my.com.google.protobuf.CodedInputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(my.com.google.logging.type.HttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A common proto for logging HTTP requests. Only contains semantics
   * defined by the HTTP specification. Product-specific logging
   * information MUST be defined in a separate message.
   * </pre>
   *
   * Protobuf type {@code google.logging.type.HttpRequest}
   */
  public static final class Builder extends
      my.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.logging.type.HttpRequest)
      my.com.google.logging.type.HttpRequestOrBuilder {
    public static final my.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return my.com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
    }

    protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return my.com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              my.com.google.logging.type.HttpRequest.class, my.com.google.logging.type.HttpRequest.Builder.class);
    }

    // Construct using my.com.google.logging.type.HttpRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (my.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      requestMethod_ = "";

      requestUrl_ = "";

      requestSize_ = 0L;

      status_ = 0;

      responseSize_ = 0L;

      userAgent_ = "";

      remoteIp_ = "";

      serverIp_ = "";

      referer_ = "";

      if (latencyBuilder_ == null) {
        latency_ = null;
      } else {
        latency_ = null;
        latencyBuilder_ = null;
      }
      cacheLookup_ = false;

      cacheHit_ = false;

      cacheValidatedWithOriginServer_ = false;

      cacheFillBytes_ = 0L;

      return this;
    }

    public my.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return my.com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
    }

    public my.com.google.logging.type.HttpRequest getDefaultInstanceForType() {
      return my.com.google.logging.type.HttpRequest.getDefaultInstance();
    }

    public my.com.google.logging.type.HttpRequest build() {
      my.com.google.logging.type.HttpRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public my.com.google.logging.type.HttpRequest buildPartial() {
      my.com.google.logging.type.HttpRequest result = new my.com.google.logging.type.HttpRequest(this);
      result.requestMethod_ = requestMethod_;
      result.requestUrl_ = requestUrl_;
      result.requestSize_ = requestSize_;
      result.status_ = status_;
      result.responseSize_ = responseSize_;
      result.userAgent_ = userAgent_;
      result.remoteIp_ = remoteIp_;
      result.serverIp_ = serverIp_;
      result.referer_ = referer_;
      if (latencyBuilder_ == null) {
        result.latency_ = latency_;
      } else {
        result.latency_ = latencyBuilder_.build();
      }
      result.cacheLookup_ = cacheLookup_;
      result.cacheHit_ = cacheHit_;
      result.cacheValidatedWithOriginServer_ = cacheValidatedWithOriginServer_;
      result.cacheFillBytes_ = cacheFillBytes_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        my.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(my.com.google.protobuf.Message other) {
      if (other instanceof my.com.google.logging.type.HttpRequest) {
        return mergeFrom((my.com.google.logging.type.HttpRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(my.com.google.logging.type.HttpRequest other) {
      if (other == my.com.google.logging.type.HttpRequest.getDefaultInstance()) return this;
      if (!other.getRequestMethod().isEmpty()) {
        requestMethod_ = other.requestMethod_;
        onChanged();
      }
      if (!other.getRequestUrl().isEmpty()) {
        requestUrl_ = other.requestUrl_;
        onChanged();
      }
      if (other.getRequestSize() != 0L) {
        setRequestSize(other.getRequestSize());
      }
      if (other.getStatus() != 0) {
        setStatus(other.getStatus());
      }
      if (other.getResponseSize() != 0L) {
        setResponseSize(other.getResponseSize());
      }
      if (!other.getUserAgent().isEmpty()) {
        userAgent_ = other.userAgent_;
        onChanged();
      }
      if (!other.getRemoteIp().isEmpty()) {
        remoteIp_ = other.remoteIp_;
        onChanged();
      }
      if (!other.getServerIp().isEmpty()) {
        serverIp_ = other.serverIp_;
        onChanged();
      }
      if (!other.getReferer().isEmpty()) {
        referer_ = other.referer_;
        onChanged();
      }
      if (other.hasLatency()) {
        mergeLatency(other.getLatency());
      }
      if (other.getCacheLookup() != false) {
        setCacheLookup(other.getCacheLookup());
      }
      if (other.getCacheHit() != false) {
        setCacheHit(other.getCacheHit());
      }
      if (other.getCacheValidatedWithOriginServer() != false) {
        setCacheValidatedWithOriginServer(other.getCacheValidatedWithOriginServer());
      }
      if (other.getCacheFillBytes() != 0L) {
        setCacheFillBytes(other.getCacheFillBytes());
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      my.com.google.logging.type.HttpRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (my.com.google.logging.type.HttpRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object requestMethod_ = "";
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public java.lang.String getRequestMethod() {
      java.lang.Object ref = requestMethod_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public my.com.google.protobuf.ByteString
        getRequestMethodBytes() {
      java.lang.Object ref = requestMethod_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        requestMethod_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder setRequestMethod(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      requestMethod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder clearRequestMethod() {
      
      requestMethod_ = getDefaultInstance().getRequestMethod();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder setRequestMethodBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      requestMethod_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object requestUrl_ = "";
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public java.lang.String getRequestUrl() {
      java.lang.Object ref = requestUrl_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public my.com.google.protobuf.ByteString
        getRequestUrlBytes() {
      java.lang.Object ref = requestUrl_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        requestUrl_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder setRequestUrl(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      requestUrl_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder clearRequestUrl() {
      
      requestUrl_ = getDefaultInstance().getRequestUrl();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder setRequestUrlBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      requestUrl_ = value;
      onChanged();
      return this;
    }

    private long requestSize_ ;
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public long getRequestSize() {
      return requestSize_;
    }
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public Builder setRequestSize(long value) {
      
      requestSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public Builder clearRequestSize() {
      
      requestSize_ = 0L;
      onChanged();
      return this;
    }

    private int status_ ;
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public int getStatus() {
      return status_;
    }
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public Builder setStatus(int value) {
      
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private long responseSize_ ;
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public long getResponseSize() {
      return responseSize_;
    }
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public Builder setResponseSize(long value) {
      
      responseSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public Builder clearResponseSize() {
      
      responseSize_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object userAgent_ = "";
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public java.lang.String getUserAgent() {
      java.lang.Object ref = userAgent_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public my.com.google.protobuf.ByteString
        getUserAgentBytes() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder setUserAgent(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      userAgent_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder clearUserAgent() {
      
      userAgent_ = getDefaultInstance().getUserAgent();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder setUserAgentBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      userAgent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object remoteIp_ = "";
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public java.lang.String getRemoteIp() {
      java.lang.Object ref = remoteIp_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public my.com.google.protobuf.ByteString
        getRemoteIpBytes() {
      java.lang.Object ref = remoteIp_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        remoteIp_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder setRemoteIp(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      remoteIp_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder clearRemoteIp() {
      
      remoteIp_ = getDefaultInstance().getRemoteIp();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder setRemoteIpBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      remoteIp_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object serverIp_ = "";
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public java.lang.String getServerIp() {
      java.lang.Object ref = serverIp_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public my.com.google.protobuf.ByteString
        getServerIpBytes() {
      java.lang.Object ref = serverIp_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        serverIp_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder setServerIp(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      serverIp_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder clearServerIp() {
      
      serverIp_ = getDefaultInstance().getServerIp();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder setServerIpBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      serverIp_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object referer_ = "";
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public java.lang.String getReferer() {
      java.lang.Object ref = referer_;
      if (!(ref instanceof java.lang.String)) {
        my.com.google.protobuf.ByteString bs =
            (my.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public my.com.google.protobuf.ByteString
        getRefererBytes() {
      java.lang.Object ref = referer_;
      if (ref instanceof String) {
        my.com.google.protobuf.ByteString b =
            my.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referer_ = b;
        return b;
      } else {
        return (my.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder setReferer(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder clearReferer() {
      
      referer_ = getDefaultInstance().getReferer();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder setRefererBytes(
        my.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referer_ = value;
      onChanged();
      return this;
    }

    private my.com.google.protobuf.Duration latency_ = null;
    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.protobuf.Duration, my.com.google.protobuf.Duration.Builder, my.com.google.protobuf.DurationOrBuilder> latencyBuilder_;
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public boolean hasLatency() {
      return latencyBuilder_ != null || latency_ != null;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public my.com.google.protobuf.Duration getLatency() {
      if (latencyBuilder_ == null) {
        return latency_ == null ? my.com.google.protobuf.Duration.getDefaultInstance() : latency_;
      } else {
        return latencyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(my.com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latency_ = value;
        onChanged();
      } else {
        latencyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(
        my.com.google.protobuf.Duration.Builder builderForValue) {
      if (latencyBuilder_ == null) {
        latency_ = builderForValue.build();
        onChanged();
      } else {
        latencyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder mergeLatency(my.com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (latency_ != null) {
          latency_ =
            my.com.google.protobuf.Duration.newBuilder(latency_).mergeFrom(value).buildPartial();
        } else {
          latency_ = value;
        }
        onChanged();
      } else {
        latencyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder clearLatency() {
      if (latencyBuilder_ == null) {
        latency_ = null;
        onChanged();
      } else {
        latency_ = null;
        latencyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public my.com.google.protobuf.Duration.Builder getLatencyBuilder() {
      
      onChanged();
      return getLatencyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public my.com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
      if (latencyBuilder_ != null) {
        return latencyBuilder_.getMessageOrBuilder();
      } else {
        return latency_ == null ?
            my.com.google.protobuf.Duration.getDefaultInstance() : latency_;
      }
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.protobuf.Duration, my.com.google.protobuf.Duration.Builder, my.com.google.protobuf.DurationOrBuilder>
        getLatencyFieldBuilder() {
      if (latencyBuilder_ == null) {
        latencyBuilder_ = new my.com.google.protobuf.SingleFieldBuilderV3<
            my.com.google.protobuf.Duration, my.com.google.protobuf.Duration.Builder, my.com.google.protobuf.DurationOrBuilder>(
                getLatency(),
                getParentForChildren(),
                isClean());
        latency_ = null;
      }
      return latencyBuilder_;
    }

    private boolean cacheLookup_ ;
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public boolean getCacheLookup() {
      return cacheLookup_;
    }
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public Builder setCacheLookup(boolean value) {
      
      cacheLookup_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public Builder clearCacheLookup() {
      
      cacheLookup_ = false;
      onChanged();
      return this;
    }

    private boolean cacheHit_ ;
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public boolean getCacheHit() {
      return cacheHit_;
    }
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public Builder setCacheHit(boolean value) {
      
      cacheHit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public Builder clearCacheHit() {
      
      cacheHit_ = false;
      onChanged();
      return this;
    }

    private boolean cacheValidatedWithOriginServer_ ;
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public boolean getCacheValidatedWithOriginServer() {
      return cacheValidatedWithOriginServer_;
    }
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public Builder setCacheValidatedWithOriginServer(boolean value) {
      
      cacheValidatedWithOriginServer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public Builder clearCacheValidatedWithOriginServer() {
      
      cacheValidatedWithOriginServer_ = false;
      onChanged();
      return this;
    }

    private long cacheFillBytes_ ;
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public long getCacheFillBytes() {
      return cacheFillBytes_;
    }
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public Builder setCacheFillBytes(long value) {
      
      cacheFillBytes_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public Builder clearCacheFillBytes() {
      
      cacheFillBytes_ = 0L;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final my.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final my.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.logging.type.HttpRequest)
  }

  // @@protoc_insertion_point(class_scope:google.logging.type.HttpRequest)
  private static final my.com.google.logging.type.HttpRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new my.com.google.logging.type.HttpRequest();
  }

  public static my.com.google.logging.type.HttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final my.com.google.protobuf.Parser<HttpRequest>
      PARSER = new my.com.google.protobuf.AbstractParser<HttpRequest>() {
    public HttpRequest parsePartialFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
        return new HttpRequest(input, extensionRegistry);
    }
  };

  public static my.com.google.protobuf.Parser<HttpRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public my.com.google.protobuf.Parser<HttpRequest> getParserForType() {
    return PARSER;
  }

  public my.com.google.logging.type.HttpRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

