// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicecontrol/v1/distribution.proto

package my.com.google.api.servicecontrol.v1;

/**
 * <pre>
 * Distribution represents a frequency distribution of double-valued sample
 * points. It contains the size of the population of sample points plus
 * additional optional information:
 *   - the arithmetic mean of the samples
 *   - the minimum and maximum of the samples
 *   - the sum-squared-deviation of the samples, used to compute variance
 *   - a histogram of the values of the sample points
 * </pre>
 *
 * Protobuf type {@code google.api.servicecontrol.v1.Distribution}
 */
public  final class Distribution extends
    my.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v1.Distribution)
    DistributionOrBuilder {
  // Use Distribution.newBuilder() to construct.
  private Distribution(my.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Distribution() {
    count_ = 0L;
    mean_ = 0D;
    minimum_ = 0D;
    maximum_ = 0D;
    sumOfSquaredDeviation_ = 0D;
    bucketCounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final my.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return my.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Distribution(
      my.com.google.protobuf.CodedInputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            count_ = input.readInt64();
            break;
          }
          case 17: {

            mean_ = input.readDouble();
            break;
          }
          case 25: {

            minimum_ = input.readDouble();
            break;
          }
          case 33: {

            maximum_ = input.readDouble();
            break;
          }
          case 41: {

            sumOfSquaredDeviation_ = input.readDouble();
            break;
          }
          case 48: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              bucketCounts_ = new java.util.ArrayList<java.lang.Long>();
              mutable_bitField0_ |= 0x00000020;
            }
            bucketCounts_.add(input.readInt64());
            break;
          }
          case 50: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020) && input.getBytesUntilLimit() > 0) {
              bucketCounts_ = new java.util.ArrayList<java.lang.Long>();
              mutable_bitField0_ |= 0x00000020;
            }
            while (input.getBytesUntilLimit() > 0) {
              bucketCounts_.add(input.readInt64());
            }
            input.popLimit(limit);
            break;
          }
          case 58: {
            my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder subBuilder = null;
            if (bucketOptionCase_ == 7) {
              subBuilder = ((my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_).toBuilder();
            }
            bucketOption_ =
                input.readMessage(my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_);
              bucketOption_ = subBuilder.buildPartial();
            }
            bucketOptionCase_ = 7;
            break;
          }
          case 66: {
            my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder subBuilder = null;
            if (bucketOptionCase_ == 8) {
              subBuilder = ((my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_).toBuilder();
            }
            bucketOption_ =
                input.readMessage(my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_);
              bucketOption_ = subBuilder.buildPartial();
            }
            bucketOptionCase_ = 8;
            break;
          }
          case 74: {
            my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder subBuilder = null;
            if (bucketOptionCase_ == 9) {
              subBuilder = ((my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_).toBuilder();
            }
            bucketOption_ =
                input.readMessage(my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_);
              bucketOption_ = subBuilder.buildPartial();
            }
            bucketOptionCase_ = 9;
            break;
          }
        }
      }
    } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new my.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = java.util.Collections.unmodifiableList(bucketCounts_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final my.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_descriptor;
  }

  protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            my.com.google.api.servicecontrol.v1.Distribution.class, my.com.google.api.servicecontrol.v1.Distribution.Builder.class);
  }

  public interface LinearBucketsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.servicecontrol.v1.Distribution.LinearBuckets)
      my.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The number of finite buckets. With the underflow and overflow buckets,
     * the total number of buckets is `num_finite_buckets` + 2.
     * See comments on `bucket_options` for details.
     * </pre>
     *
     * <code>int32 num_finite_buckets = 1;</code>
     */
    int getNumFiniteBuckets();

    /**
     * <pre>
     * The i'th linear bucket covers the interval
     *   [offset + (i-1) * width, offset + i * width)
     * where i ranges from 1 to num_finite_buckets, inclusive.
     * Must be strictly positive.
     * </pre>
     *
     * <code>double width = 2;</code>
     */
    double getWidth();

    /**
     * <pre>
     * The i'th linear bucket covers the interval
     *   [offset + (i-1) * width, offset + i * width)
     * where i ranges from 1 to num_finite_buckets, inclusive.
     * </pre>
     *
     * <code>double offset = 3;</code>
     */
    double getOffset();
  }
  /**
   * <pre>
   * Describing buckets with constant width.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v1.Distribution.LinearBuckets}
   */
  public  static final class LinearBuckets extends
      my.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v1.Distribution.LinearBuckets)
      LinearBucketsOrBuilder {
    // Use LinearBuckets.newBuilder() to construct.
    private LinearBuckets(my.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LinearBuckets() {
      numFiniteBuckets_ = 0;
      width_ = 0D;
      offset_ = 0D;
    }

    @java.lang.Override
    public final my.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return my.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private LinearBuckets(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              numFiniteBuckets_ = input.readInt32();
              break;
            }
            case 17: {

              width_ = input.readDouble();
              break;
            }
            case 25: {

              offset_ = input.readDouble();
              break;
            }
          }
        }
      } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new my.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final my.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_LinearBuckets_descriptor;
    }

    protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_LinearBuckets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder.class);
    }

    public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
    private int numFiniteBuckets_;
    /**
     * <pre>
     * The number of finite buckets. With the underflow and overflow buckets,
     * the total number of buckets is `num_finite_buckets` + 2.
     * See comments on `bucket_options` for details.
     * </pre>
     *
     * <code>int32 num_finite_buckets = 1;</code>
     */
    public int getNumFiniteBuckets() {
      return numFiniteBuckets_;
    }

    public static final int WIDTH_FIELD_NUMBER = 2;
    private double width_;
    /**
     * <pre>
     * The i'th linear bucket covers the interval
     *   [offset + (i-1) * width, offset + i * width)
     * where i ranges from 1 to num_finite_buckets, inclusive.
     * Must be strictly positive.
     * </pre>
     *
     * <code>double width = 2;</code>
     */
    public double getWidth() {
      return width_;
    }

    public static final int OFFSET_FIELD_NUMBER = 3;
    private double offset_;
    /**
     * <pre>
     * The i'th linear bucket covers the interval
     *   [offset + (i-1) * width, offset + i * width)
     * where i ranges from 1 to num_finite_buckets, inclusive.
     * </pre>
     *
     * <code>double offset = 3;</code>
     */
    public double getOffset() {
      return offset_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(my.com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (numFiniteBuckets_ != 0) {
        output.writeInt32(1, numFiniteBuckets_);
      }
      if (width_ != 0D) {
        output.writeDouble(2, width_);
      }
      if (offset_ != 0D) {
        output.writeDouble(3, offset_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (numFiniteBuckets_ != 0) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, numFiniteBuckets_);
      }
      if (width_ != 0D) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeDoubleSize(2, width_);
      }
      if (offset_ != 0D) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeDoubleSize(3, offset_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets)) {
        return super.equals(obj);
      }
      my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets other = (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) obj;

      boolean result = true;
      result = result && (getNumFiniteBuckets()
          == other.getNumFiniteBuckets());
      result = result && (
          java.lang.Double.doubleToLongBits(getWidth())
          == java.lang.Double.doubleToLongBits(
              other.getWidth()));
      result = result && (
          java.lang.Double.doubleToLongBits(getOffset())
          == java.lang.Double.doubleToLongBits(
              other.getOffset()));
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getNumFiniteBuckets();
      hash = (37 * hash) + WIDTH_FIELD_NUMBER;
      hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getWidth()));
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getOffset()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        my.com.google.protobuf.ByteString data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        my.com.google.protobuf.ByteString data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(byte[] data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        byte[] data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseDelimitedFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describing buckets with constant width.
     * </pre>
     *
     * Protobuf type {@code google.api.servicecontrol.v1.Distribution.LinearBuckets}
     */
    public static final class Builder extends
        my.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v1.Distribution.LinearBuckets)
        my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder {
      public static final my.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_LinearBuckets_descriptor;
      }

      protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_LinearBuckets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder.class);
      }

      // Construct using my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (my.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        numFiniteBuckets_ = 0;

        width_ = 0D;

        offset_ = 0D;

        return this;
      }

      public my.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_LinearBuckets_descriptor;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets getDefaultInstanceForType() {
        return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
      }

      public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets build() {
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets buildPartial() {
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets result = new my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets(this);
        result.numFiniteBuckets_ = numFiniteBuckets_;
        result.width_ = width_;
        result.offset_ = offset_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          my.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(my.com.google.protobuf.Message other) {
        if (other instanceof my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) {
          return mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets other) {
        if (other == my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance()) return this;
        if (other.getNumFiniteBuckets() != 0) {
          setNumFiniteBuckets(other.getNumFiniteBuckets());
        }
        if (other.getWidth() != 0D) {
          setWidth(other.getWidth());
        }
        if (other.getOffset() != 0D) {
          setOffset(other.getOffset());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int numFiniteBuckets_ ;
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public Builder setNumFiniteBuckets(int value) {
        
        numFiniteBuckets_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public Builder clearNumFiniteBuckets() {
        
        numFiniteBuckets_ = 0;
        onChanged();
        return this;
      }

      private double width_ ;
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * Must be strictly positive.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      public double getWidth() {
        return width_;
      }
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * Must be strictly positive.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      public Builder setWidth(double value) {
        
        width_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * Must be strictly positive.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      public Builder clearWidth() {
        
        width_ = 0D;
        onChanged();
        return this;
      }

      private double offset_ ;
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      public double getOffset() {
        return offset_;
      }
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      public Builder setOffset(double value) {
        
        offset_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The i'th linear bucket covers the interval
       *   [offset + (i-1) * width, offset + i * width)
       * where i ranges from 1 to num_finite_buckets, inclusive.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      public Builder clearOffset() {
        
        offset_ = 0D;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v1.Distribution.LinearBuckets)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v1.Distribution.LinearBuckets)
    private static final my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets();
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final my.com.google.protobuf.Parser<LinearBuckets>
        PARSER = new my.com.google.protobuf.AbstractParser<LinearBuckets>() {
      public LinearBuckets parsePartialFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws my.com.google.protobuf.InvalidProtocolBufferException {
          return new LinearBuckets(input, extensionRegistry);
      }
    };

    public static my.com.google.protobuf.Parser<LinearBuckets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public my.com.google.protobuf.Parser<LinearBuckets> getParserForType() {
      return PARSER;
    }

    public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExponentialBucketsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.servicecontrol.v1.Distribution.ExponentialBuckets)
      my.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The number of finite buckets. With the underflow and overflow buckets,
     * the total number of buckets is `num_finite_buckets` + 2.
     * See comments on `bucket_options` for details.
     * </pre>
     *
     * <code>int32 num_finite_buckets = 1;</code>
     */
    int getNumFiniteBuckets();

    /**
     * <pre>
     * The i'th exponential bucket covers the interval
     *   [scale * growth_factor^(i-1), scale * growth_factor^i)
     * where i ranges from 1 to num_finite_buckets inclusive.
     * Must be larger than 1.0.
     * </pre>
     *
     * <code>double growth_factor = 2;</code>
     */
    double getGrowthFactor();

    /**
     * <pre>
     * The i'th exponential bucket covers the interval
     *   [scale * growth_factor^(i-1), scale * growth_factor^i)
     * where i ranges from 1 to num_finite_buckets inclusive.
     * Must be &gt; 0.
     * </pre>
     *
     * <code>double scale = 3;</code>
     */
    double getScale();
  }
  /**
   * <pre>
   * Describing buckets with exponentially growing width.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v1.Distribution.ExponentialBuckets}
   */
  public  static final class ExponentialBuckets extends
      my.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v1.Distribution.ExponentialBuckets)
      ExponentialBucketsOrBuilder {
    // Use ExponentialBuckets.newBuilder() to construct.
    private ExponentialBuckets(my.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ExponentialBuckets() {
      numFiniteBuckets_ = 0;
      growthFactor_ = 0D;
      scale_ = 0D;
    }

    @java.lang.Override
    public final my.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return my.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ExponentialBuckets(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              numFiniteBuckets_ = input.readInt32();
              break;
            }
            case 17: {

              growthFactor_ = input.readDouble();
              break;
            }
            case 25: {

              scale_ = input.readDouble();
              break;
            }
          }
        }
      } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new my.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final my.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExponentialBuckets_descriptor;
    }

    protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExponentialBuckets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder.class);
    }

    public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
    private int numFiniteBuckets_;
    /**
     * <pre>
     * The number of finite buckets. With the underflow and overflow buckets,
     * the total number of buckets is `num_finite_buckets` + 2.
     * See comments on `bucket_options` for details.
     * </pre>
     *
     * <code>int32 num_finite_buckets = 1;</code>
     */
    public int getNumFiniteBuckets() {
      return numFiniteBuckets_;
    }

    public static final int GROWTH_FACTOR_FIELD_NUMBER = 2;
    private double growthFactor_;
    /**
     * <pre>
     * The i'th exponential bucket covers the interval
     *   [scale * growth_factor^(i-1), scale * growth_factor^i)
     * where i ranges from 1 to num_finite_buckets inclusive.
     * Must be larger than 1.0.
     * </pre>
     *
     * <code>double growth_factor = 2;</code>
     */
    public double getGrowthFactor() {
      return growthFactor_;
    }

    public static final int SCALE_FIELD_NUMBER = 3;
    private double scale_;
    /**
     * <pre>
     * The i'th exponential bucket covers the interval
     *   [scale * growth_factor^(i-1), scale * growth_factor^i)
     * where i ranges from 1 to num_finite_buckets inclusive.
     * Must be &gt; 0.
     * </pre>
     *
     * <code>double scale = 3;</code>
     */
    public double getScale() {
      return scale_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(my.com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (numFiniteBuckets_ != 0) {
        output.writeInt32(1, numFiniteBuckets_);
      }
      if (growthFactor_ != 0D) {
        output.writeDouble(2, growthFactor_);
      }
      if (scale_ != 0D) {
        output.writeDouble(3, scale_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (numFiniteBuckets_ != 0) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, numFiniteBuckets_);
      }
      if (growthFactor_ != 0D) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeDoubleSize(2, growthFactor_);
      }
      if (scale_ != 0D) {
        size += my.com.google.protobuf.CodedOutputStream
          .computeDoubleSize(3, scale_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets)) {
        return super.equals(obj);
      }
      my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets other = (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) obj;

      boolean result = true;
      result = result && (getNumFiniteBuckets()
          == other.getNumFiniteBuckets());
      result = result && (
          java.lang.Double.doubleToLongBits(getGrowthFactor())
          == java.lang.Double.doubleToLongBits(
              other.getGrowthFactor()));
      result = result && (
          java.lang.Double.doubleToLongBits(getScale())
          == java.lang.Double.doubleToLongBits(
              other.getScale()));
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getNumFiniteBuckets();
      hash = (37 * hash) + GROWTH_FACTOR_FIELD_NUMBER;
      hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getGrowthFactor()));
      hash = (37 * hash) + SCALE_FIELD_NUMBER;
      hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getScale()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        my.com.google.protobuf.ByteString data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        my.com.google.protobuf.ByteString data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(byte[] data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        byte[] data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseDelimitedFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describing buckets with exponentially growing width.
     * </pre>
     *
     * Protobuf type {@code google.api.servicecontrol.v1.Distribution.ExponentialBuckets}
     */
    public static final class Builder extends
        my.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v1.Distribution.ExponentialBuckets)
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder {
      public static final my.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExponentialBuckets_descriptor;
      }

      protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExponentialBuckets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder.class);
      }

      // Construct using my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (my.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        numFiniteBuckets_ = 0;

        growthFactor_ = 0D;

        scale_ = 0D;

        return this;
      }

      public my.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExponentialBuckets_descriptor;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets getDefaultInstanceForType() {
        return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets build() {
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets buildPartial() {
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets result = new my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets(this);
        result.numFiniteBuckets_ = numFiniteBuckets_;
        result.growthFactor_ = growthFactor_;
        result.scale_ = scale_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          my.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(my.com.google.protobuf.Message other) {
        if (other instanceof my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) {
          return mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets other) {
        if (other == my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance()) return this;
        if (other.getNumFiniteBuckets() != 0) {
          setNumFiniteBuckets(other.getNumFiniteBuckets());
        }
        if (other.getGrowthFactor() != 0D) {
          setGrowthFactor(other.getGrowthFactor());
        }
        if (other.getScale() != 0D) {
          setScale(other.getScale());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int numFiniteBuckets_ ;
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public Builder setNumFiniteBuckets(int value) {
        
        numFiniteBuckets_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The number of finite buckets. With the underflow and overflow buckets,
       * the total number of buckets is `num_finite_buckets` + 2.
       * See comments on `bucket_options` for details.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public Builder clearNumFiniteBuckets() {
        
        numFiniteBuckets_ = 0;
        onChanged();
        return this;
      }

      private double growthFactor_ ;
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be larger than 1.0.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      public double getGrowthFactor() {
        return growthFactor_;
      }
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be larger than 1.0.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      public Builder setGrowthFactor(double value) {
        
        growthFactor_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be larger than 1.0.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      public Builder clearGrowthFactor() {
        
        growthFactor_ = 0D;
        onChanged();
        return this;
      }

      private double scale_ ;
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be &gt; 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      public double getScale() {
        return scale_;
      }
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be &gt; 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      public Builder setScale(double value) {
        
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The i'th exponential bucket covers the interval
       *   [scale * growth_factor^(i-1), scale * growth_factor^i)
       * where i ranges from 1 to num_finite_buckets inclusive.
       * Must be &gt; 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      public Builder clearScale() {
        
        scale_ = 0D;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v1.Distribution.ExponentialBuckets)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v1.Distribution.ExponentialBuckets)
    private static final my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets();
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final my.com.google.protobuf.Parser<ExponentialBuckets>
        PARSER = new my.com.google.protobuf.AbstractParser<ExponentialBuckets>() {
      public ExponentialBuckets parsePartialFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws my.com.google.protobuf.InvalidProtocolBufferException {
          return new ExponentialBuckets(input, extensionRegistry);
      }
    };

    public static my.com.google.protobuf.Parser<ExponentialBuckets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public my.com.google.protobuf.Parser<ExponentialBuckets> getParserForType() {
      return PARSER;
    }

    public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExplicitBucketsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.servicecontrol.v1.Distribution.ExplicitBuckets)
      my.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    java.util.List<java.lang.Double> getBoundsList();
    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    int getBoundsCount();
    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    double getBounds(int index);
  }
  /**
   * <pre>
   * Describing buckets with arbitrary user-provided width.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v1.Distribution.ExplicitBuckets}
   */
  public  static final class ExplicitBuckets extends
      my.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v1.Distribution.ExplicitBuckets)
      ExplicitBucketsOrBuilder {
    // Use ExplicitBuckets.newBuilder() to construct.
    private ExplicitBuckets(my.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ExplicitBuckets() {
      bounds_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final my.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return my.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ExplicitBuckets(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 9: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                bounds_ = new java.util.ArrayList<java.lang.Double>();
                mutable_bitField0_ |= 0x00000001;
              }
              bounds_.add(input.readDouble());
              break;
            }
            case 10: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001) && input.getBytesUntilLimit() > 0) {
                bounds_ = new java.util.ArrayList<java.lang.Double>();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                bounds_.add(input.readDouble());
              }
              input.popLimit(limit);
              break;
            }
          }
        }
      } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new my.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          bounds_ = java.util.Collections.unmodifiableList(bounds_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final my.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExplicitBuckets_descriptor;
    }

    protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExplicitBuckets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder.class);
    }

    public static final int BOUNDS_FIELD_NUMBER = 1;
    private java.util.List<java.lang.Double> bounds_;
    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    public java.util.List<java.lang.Double>
        getBoundsList() {
      return bounds_;
    }
    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    public int getBoundsCount() {
      return bounds_.size();
    }
    /**
     * <pre>
     * 'bound' is a list of strictly increasing boundaries between
     * buckets. Note that a list of length N-1 defines N buckets because
     * of fenceposting. See comments on `bucket_options` for details.
     * The i'th finite bucket covers the interval
     *   [bound[i-1], bound[i])
     * where i ranges from 1 to bound_size() - 1. Note that there are no
     * finite buckets at all if 'bound' only contains a single element; in
     * that special case the single bound defines the boundary between the
     * underflow and overflow buckets.
     * bucket number                   lower bound    upper bound
     *  i == 0 (underflow)              -inf           bound[i]
     *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
     *  i == bound_size() (overflow)    bound[i-1]     +inf
     * </pre>
     *
     * <code>repeated double bounds = 1;</code>
     */
    public double getBounds(int index) {
      return bounds_.get(index);
    }
    private int boundsMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(my.com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (getBoundsList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(boundsMemoizedSerializedSize);
      }
      for (int i = 0; i < bounds_.size(); i++) {
        output.writeDoubleNoTag(bounds_.get(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        dataSize = 8 * getBoundsList().size();
        size += dataSize;
        if (!getBoundsList().isEmpty()) {
          size += 1;
          size += my.com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        boundsMemoizedSerializedSize = dataSize;
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets)) {
        return super.equals(obj);
      }
      my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets other = (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) obj;

      boolean result = true;
      result = result && getBoundsList()
          .equals(other.getBoundsList());
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getBoundsCount() > 0) {
        hash = (37 * hash) + BOUNDS_FIELD_NUMBER;
        hash = (53 * hash) + getBoundsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        my.com.google.protobuf.ByteString data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        my.com.google.protobuf.ByteString data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(byte[] data)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        byte[] data,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseDelimitedFrom(
        java.io.InputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parseFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return my.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describing buckets with arbitrary user-provided width.
     * </pre>
     *
     * Protobuf type {@code google.api.servicecontrol.v1.Distribution.ExplicitBuckets}
     */
    public static final class Builder extends
        my.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v1.Distribution.ExplicitBuckets)
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder {
      public static final my.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExplicitBuckets_descriptor;
      }

      protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExplicitBuckets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.class, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder.class);
      }

      // Construct using my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (my.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        bounds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public my.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_ExplicitBuckets_descriptor;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets getDefaultInstanceForType() {
        return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets build() {
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets buildPartial() {
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets result = new my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          bounds_ = java.util.Collections.unmodifiableList(bounds_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.bounds_ = bounds_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          my.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          my.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(my.com.google.protobuf.Message other) {
        if (other instanceof my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) {
          return mergeFrom((my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets other) {
        if (other == my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance()) return this;
        if (!other.bounds_.isEmpty()) {
          if (bounds_.isEmpty()) {
            bounds_ = other.bounds_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBoundsIsMutable();
            bounds_.addAll(other.bounds_);
          }
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<java.lang.Double> bounds_ = java.util.Collections.emptyList();
      private void ensureBoundsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          bounds_ = new java.util.ArrayList<java.lang.Double>(bounds_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public java.util.List<java.lang.Double>
          getBoundsList() {
        return java.util.Collections.unmodifiableList(bounds_);
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public int getBoundsCount() {
        return bounds_.size();
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public double getBounds(int index) {
        return bounds_.get(index);
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public Builder setBounds(
          int index, double value) {
        ensureBoundsIsMutable();
        bounds_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public Builder addBounds(double value) {
        ensureBoundsIsMutable();
        bounds_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public Builder addAllBounds(
          java.lang.Iterable<? extends java.lang.Double> values) {
        ensureBoundsIsMutable();
        my.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, bounds_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 'bound' is a list of strictly increasing boundaries between
       * buckets. Note that a list of length N-1 defines N buckets because
       * of fenceposting. See comments on `bucket_options` for details.
       * The i'th finite bucket covers the interval
       *   [bound[i-1], bound[i])
       * where i ranges from 1 to bound_size() - 1. Note that there are no
       * finite buckets at all if 'bound' only contains a single element; in
       * that special case the single bound defines the boundary between the
       * underflow and overflow buckets.
       * bucket number                   lower bound    upper bound
       *  i == 0 (underflow)              -inf           bound[i]
       *  0 &lt; i &lt; bound_size()            bound[i-1]     bound[i]
       *  i == bound_size() (overflow)    bound[i-1]     +inf
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public Builder clearBounds() {
        bounds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final my.com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v1.Distribution.ExplicitBuckets)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v1.Distribution.ExplicitBuckets)
    private static final my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets();
    }

    public static my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final my.com.google.protobuf.Parser<ExplicitBuckets>
        PARSER = new my.com.google.protobuf.AbstractParser<ExplicitBuckets>() {
      public ExplicitBuckets parsePartialFrom(
          my.com.google.protobuf.CodedInputStream input,
          my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws my.com.google.protobuf.InvalidProtocolBufferException {
          return new ExplicitBuckets(input, extensionRegistry);
      }
    };

    public static my.com.google.protobuf.Parser<ExplicitBuckets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public my.com.google.protobuf.Parser<ExplicitBuckets> getParserForType() {
      return PARSER;
    }

    public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  private int bucketOptionCase_ = 0;
  private java.lang.Object bucketOption_;
  public enum BucketOptionCase
      implements my.com.google.protobuf.Internal.EnumLite {
    LINEAR_BUCKETS(7),
    EXPONENTIAL_BUCKETS(8),
    EXPLICIT_BUCKETS(9),
    BUCKETOPTION_NOT_SET(0);
    private final int value;
    private BucketOptionCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BucketOptionCase valueOf(int value) {
      return forNumber(value);
    }

    public static BucketOptionCase forNumber(int value) {
      switch (value) {
        case 7: return LINEAR_BUCKETS;
        case 8: return EXPONENTIAL_BUCKETS;
        case 9: return EXPLICIT_BUCKETS;
        case 0: return BUCKETOPTION_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public BucketOptionCase
  getBucketOptionCase() {
    return BucketOptionCase.forNumber(
        bucketOptionCase_);
  }

  public static final int COUNT_FIELD_NUMBER = 1;
  private long count_;
  /**
   * <pre>
   * The total number of samples in the distribution. Must be &gt;= 0.
   * </pre>
   *
   * <code>int64 count = 1;</code>
   */
  public long getCount() {
    return count_;
  }

  public static final int MEAN_FIELD_NUMBER = 2;
  private double mean_;
  /**
   * <pre>
   * The arithmetic mean of the samples in the distribution. If `count` is
   * zero then this field must be zero.
   * </pre>
   *
   * <code>double mean = 2;</code>
   */
  public double getMean() {
    return mean_;
  }

  public static final int MINIMUM_FIELD_NUMBER = 3;
  private double minimum_;
  /**
   * <pre>
   * The minimum of the population of values. Ignored if `count` is zero.
   * </pre>
   *
   * <code>double minimum = 3;</code>
   */
  public double getMinimum() {
    return minimum_;
  }

  public static final int MAXIMUM_FIELD_NUMBER = 4;
  private double maximum_;
  /**
   * <pre>
   * The maximum of the population of values. Ignored if `count` is zero.
   * </pre>
   *
   * <code>double maximum = 4;</code>
   */
  public double getMaximum() {
    return maximum_;
  }

  public static final int SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER = 5;
  private double sumOfSquaredDeviation_;
  /**
   * <pre>
   * The sum of squared deviations from the mean:
   *   Sum[i=1..count]((x_i - mean)^2)
   * where each x_i is a sample values. If `count` is zero then this field
   * must be zero, otherwise validation of the request fails.
   * </pre>
   *
   * <code>double sum_of_squared_deviation = 5;</code>
   */
  public double getSumOfSquaredDeviation() {
    return sumOfSquaredDeviation_;
  }

  public static final int BUCKET_COUNTS_FIELD_NUMBER = 6;
  private java.util.List<java.lang.Long> bucketCounts_;
  /**
   * <pre>
   * The number of samples in each histogram bucket. `bucket_counts` are
   * optional. If present, they must sum to the `count` value.
   * The buckets are defined below in `bucket_option`. There are N buckets.
   * `bucket_counts[0]` is the number of samples in the underflow bucket.
   * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
   * in each of the finite buckets. And `bucket_counts[N] is the number
   * of samples in the overflow bucket. See the comments of `bucket_option`
   * below for more details.
   * Any suffix of trailing zeros may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 6;</code>
   */
  public java.util.List<java.lang.Long>
      getBucketCountsList() {
    return bucketCounts_;
  }
  /**
   * <pre>
   * The number of samples in each histogram bucket. `bucket_counts` are
   * optional. If present, they must sum to the `count` value.
   * The buckets are defined below in `bucket_option`. There are N buckets.
   * `bucket_counts[0]` is the number of samples in the underflow bucket.
   * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
   * in each of the finite buckets. And `bucket_counts[N] is the number
   * of samples in the overflow bucket. See the comments of `bucket_option`
   * below for more details.
   * Any suffix of trailing zeros may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 6;</code>
   */
  public int getBucketCountsCount() {
    return bucketCounts_.size();
  }
  /**
   * <pre>
   * The number of samples in each histogram bucket. `bucket_counts` are
   * optional. If present, they must sum to the `count` value.
   * The buckets are defined below in `bucket_option`. There are N buckets.
   * `bucket_counts[0]` is the number of samples in the underflow bucket.
   * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
   * in each of the finite buckets. And `bucket_counts[N] is the number
   * of samples in the overflow bucket. See the comments of `bucket_option`
   * below for more details.
   * Any suffix of trailing zeros may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 6;</code>
   */
  public long getBucketCounts(int index) {
    return bucketCounts_.get(index);
  }
  private int bucketCountsMemoizedSerializedSize = -1;

  public static final int LINEAR_BUCKETS_FIELD_NUMBER = 7;
  /**
   * <pre>
   * Buckets with constant width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets getLinearBuckets() {
    if (bucketOptionCase_ == 7) {
       return (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
  }
  /**
   * <pre>
   * Buckets with constant width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder getLinearBucketsOrBuilder() {
    if (bucketOptionCase_ == 7) {
       return (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
  }

  public static final int EXPONENTIAL_BUCKETS_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Buckets with exponentially growing width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets getExponentialBuckets() {
    if (bucketOptionCase_ == 8) {
       return (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
  }
  /**
   * <pre>
   * Buckets with exponentially growing width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder getExponentialBucketsOrBuilder() {
    if (bucketOptionCase_ == 8) {
       return (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
  }

  public static final int EXPLICIT_BUCKETS_FIELD_NUMBER = 9;
  /**
   * <pre>
   * Buckets with arbitrary user-provided width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets getExplicitBuckets() {
    if (bucketOptionCase_ == 9) {
       return (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
  }
  /**
   * <pre>
   * Buckets with arbitrary user-provided width.
   * </pre>
   *
   * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
   */
  public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder getExplicitBucketsOrBuilder() {
    if (bucketOptionCase_ == 9) {
       return (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_;
    }
    return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(my.com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (count_ != 0L) {
      output.writeInt64(1, count_);
    }
    if (mean_ != 0D) {
      output.writeDouble(2, mean_);
    }
    if (minimum_ != 0D) {
      output.writeDouble(3, minimum_);
    }
    if (maximum_ != 0D) {
      output.writeDouble(4, maximum_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      output.writeDouble(5, sumOfSquaredDeviation_);
    }
    if (getBucketCountsList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(bucketCountsMemoizedSerializedSize);
    }
    for (int i = 0; i < bucketCounts_.size(); i++) {
      output.writeInt64NoTag(bucketCounts_.get(i));
    }
    if (bucketOptionCase_ == 7) {
      output.writeMessage(7, (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_);
    }
    if (bucketOptionCase_ == 8) {
      output.writeMessage(8, (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_);
    }
    if (bucketOptionCase_ == 9) {
      output.writeMessage(9, (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (count_ != 0L) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeInt64Size(1, count_);
    }
    if (mean_ != 0D) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, mean_);
    }
    if (minimum_ != 0D) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeDoubleSize(3, minimum_);
    }
    if (maximum_ != 0D) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeDoubleSize(4, maximum_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeDoubleSize(5, sumOfSquaredDeviation_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < bucketCounts_.size(); i++) {
        dataSize += my.com.google.protobuf.CodedOutputStream
          .computeInt64SizeNoTag(bucketCounts_.get(i));
      }
      size += dataSize;
      if (!getBucketCountsList().isEmpty()) {
        size += 1;
        size += my.com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      bucketCountsMemoizedSerializedSize = dataSize;
    }
    if (bucketOptionCase_ == 7) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_);
    }
    if (bucketOptionCase_ == 8) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_);
    }
    if (bucketOptionCase_ == 9) {
      size += my.com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof my.com.google.api.servicecontrol.v1.Distribution)) {
      return super.equals(obj);
    }
    my.com.google.api.servicecontrol.v1.Distribution other = (my.com.google.api.servicecontrol.v1.Distribution) obj;

    boolean result = true;
    result = result && (getCount()
        == other.getCount());
    result = result && (
        java.lang.Double.doubleToLongBits(getMean())
        == java.lang.Double.doubleToLongBits(
            other.getMean()));
    result = result && (
        java.lang.Double.doubleToLongBits(getMinimum())
        == java.lang.Double.doubleToLongBits(
            other.getMinimum()));
    result = result && (
        java.lang.Double.doubleToLongBits(getMaximum())
        == java.lang.Double.doubleToLongBits(
            other.getMaximum()));
    result = result && (
        java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation())
        == java.lang.Double.doubleToLongBits(
            other.getSumOfSquaredDeviation()));
    result = result && getBucketCountsList()
        .equals(other.getBucketCountsList());
    result = result && getBucketOptionCase().equals(
        other.getBucketOptionCase());
    if (!result) return false;
    switch (bucketOptionCase_) {
      case 7:
        result = result && getLinearBuckets()
            .equals(other.getLinearBuckets());
        break;
      case 8:
        result = result && getExponentialBuckets()
            .equals(other.getExponentialBuckets());
        break;
      case 9:
        result = result && getExplicitBuckets()
            .equals(other.getExplicitBuckets());
        break;
      case 0:
      default:
    }
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        getCount());
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + MINIMUM_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getMinimum()));
    hash = (37 * hash) + MAXIMUM_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getMaximum()));
    hash = (37 * hash) + SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER;
    hash = (53 * hash) + my.com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation()));
    if (getBucketCountsCount() > 0) {
      hash = (37 * hash) + BUCKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketCountsList().hashCode();
    }
    switch (bucketOptionCase_) {
      case 7:
        hash = (37 * hash) + LINEAR_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getLinearBuckets().hashCode();
        break;
      case 8:
        hash = (37 * hash) + EXPONENTIAL_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getExponentialBuckets().hashCode();
        break;
      case 9:
        hash = (37 * hash) + EXPLICIT_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getExplicitBuckets().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      my.com.google.protobuf.ByteString data)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      my.com.google.protobuf.ByteString data,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(byte[] data)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      byte[] data,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws my.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      java.io.InputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseDelimitedFrom(
      java.io.InputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      my.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static my.com.google.api.servicecontrol.v1.Distribution parseFrom(
      my.com.google.protobuf.CodedInputStream input,
      my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return my.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(my.com.google.api.servicecontrol.v1.Distribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Distribution represents a frequency distribution of double-valued sample
   * points. It contains the size of the population of sample points plus
   * additional optional information:
   *   - the arithmetic mean of the samples
   *   - the minimum and maximum of the samples
   *   - the sum-squared-deviation of the samples, used to compute variance
   *   - a histogram of the values of the sample points
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v1.Distribution}
   */
  public static final class Builder extends
      my.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v1.Distribution)
      my.com.google.api.servicecontrol.v1.DistributionOrBuilder {
    public static final my.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_descriptor;
    }

    protected my.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              my.com.google.api.servicecontrol.v1.Distribution.class, my.com.google.api.servicecontrol.v1.Distribution.Builder.class);
    }

    // Construct using my.com.google.api.servicecontrol.v1.Distribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        my.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (my.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      count_ = 0L;

      mean_ = 0D;

      minimum_ = 0D;

      maximum_ = 0D;

      sumOfSquaredDeviation_ = 0D;

      bucketCounts_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      bucketOptionCase_ = 0;
      bucketOption_ = null;
      return this;
    }

    public my.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return my.com.google.api.servicecontrol.v1.DistributionProto.internal_static_google_api_servicecontrol_v1_Distribution_descriptor;
    }

    public my.com.google.api.servicecontrol.v1.Distribution getDefaultInstanceForType() {
      return my.com.google.api.servicecontrol.v1.Distribution.getDefaultInstance();
    }

    public my.com.google.api.servicecontrol.v1.Distribution build() {
      my.com.google.api.servicecontrol.v1.Distribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public my.com.google.api.servicecontrol.v1.Distribution buildPartial() {
      my.com.google.api.servicecontrol.v1.Distribution result = new my.com.google.api.servicecontrol.v1.Distribution(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.count_ = count_;
      result.mean_ = mean_;
      result.minimum_ = minimum_;
      result.maximum_ = maximum_;
      result.sumOfSquaredDeviation_ = sumOfSquaredDeviation_;
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = java.util.Collections.unmodifiableList(bucketCounts_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.bucketCounts_ = bucketCounts_;
      if (bucketOptionCase_ == 7) {
        if (linearBucketsBuilder_ == null) {
          result.bucketOption_ = bucketOption_;
        } else {
          result.bucketOption_ = linearBucketsBuilder_.build();
        }
      }
      if (bucketOptionCase_ == 8) {
        if (exponentialBucketsBuilder_ == null) {
          result.bucketOption_ = bucketOption_;
        } else {
          result.bucketOption_ = exponentialBucketsBuilder_.build();
        }
      }
      if (bucketOptionCase_ == 9) {
        if (explicitBucketsBuilder_ == null) {
          result.bucketOption_ = bucketOption_;
        } else {
          result.bucketOption_ = explicitBucketsBuilder_.build();
        }
      }
      result.bitField0_ = to_bitField0_;
      result.bucketOptionCase_ = bucketOptionCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        my.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        my.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(my.com.google.protobuf.Message other) {
      if (other instanceof my.com.google.api.servicecontrol.v1.Distribution) {
        return mergeFrom((my.com.google.api.servicecontrol.v1.Distribution)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(my.com.google.api.servicecontrol.v1.Distribution other) {
      if (other == my.com.google.api.servicecontrol.v1.Distribution.getDefaultInstance()) return this;
      if (other.getCount() != 0L) {
        setCount(other.getCount());
      }
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getMinimum() != 0D) {
        setMinimum(other.getMinimum());
      }
      if (other.getMaximum() != 0D) {
        setMaximum(other.getMaximum());
      }
      if (other.getSumOfSquaredDeviation() != 0D) {
        setSumOfSquaredDeviation(other.getSumOfSquaredDeviation());
      }
      if (!other.bucketCounts_.isEmpty()) {
        if (bucketCounts_.isEmpty()) {
          bucketCounts_ = other.bucketCounts_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureBucketCountsIsMutable();
          bucketCounts_.addAll(other.bucketCounts_);
        }
        onChanged();
      }
      switch (other.getBucketOptionCase()) {
        case LINEAR_BUCKETS: {
          mergeLinearBuckets(other.getLinearBuckets());
          break;
        }
        case EXPONENTIAL_BUCKETS: {
          mergeExponentialBuckets(other.getExponentialBuckets());
          break;
        }
        case EXPLICIT_BUCKETS: {
          mergeExplicitBuckets(other.getExplicitBuckets());
          break;
        }
        case BUCKETOPTION_NOT_SET: {
          break;
        }
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      my.com.google.api.servicecontrol.v1.Distribution parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (my.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (my.com.google.api.servicecontrol.v1.Distribution) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bucketOptionCase_ = 0;
    private java.lang.Object bucketOption_;
    public BucketOptionCase
        getBucketOptionCase() {
      return BucketOptionCase.forNumber(
          bucketOptionCase_);
    }

    public Builder clearBucketOption() {
      bucketOptionCase_ = 0;
      bucketOption_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private long count_ ;
    /**
     * <pre>
     * The total number of samples in the distribution. Must be &gt;= 0.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public long getCount() {
      return count_;
    }
    /**
     * <pre>
     * The total number of samples in the distribution. Must be &gt;= 0.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder setCount(long value) {
      
      count_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The total number of samples in the distribution. Must be &gt;= 0.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder clearCount() {
      
      count_ = 0L;
      onChanged();
      return this;
    }

    private double mean_ ;
    /**
     * <pre>
     * The arithmetic mean of the samples in the distribution. If `count` is
     * zero then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public double getMean() {
      return mean_;
    }
    /**
     * <pre>
     * The arithmetic mean of the samples in the distribution. If `count` is
     * zero then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder setMean(double value) {
      
      mean_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The arithmetic mean of the samples in the distribution. If `count` is
     * zero then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder clearMean() {
      
      mean_ = 0D;
      onChanged();
      return this;
    }

    private double minimum_ ;
    /**
     * <pre>
     * The minimum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double minimum = 3;</code>
     */
    public double getMinimum() {
      return minimum_;
    }
    /**
     * <pre>
     * The minimum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double minimum = 3;</code>
     */
    public Builder setMinimum(double value) {
      
      minimum_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The minimum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double minimum = 3;</code>
     */
    public Builder clearMinimum() {
      
      minimum_ = 0D;
      onChanged();
      return this;
    }

    private double maximum_ ;
    /**
     * <pre>
     * The maximum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double maximum = 4;</code>
     */
    public double getMaximum() {
      return maximum_;
    }
    /**
     * <pre>
     * The maximum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double maximum = 4;</code>
     */
    public Builder setMaximum(double value) {
      
      maximum_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum of the population of values. Ignored if `count` is zero.
     * </pre>
     *
     * <code>double maximum = 4;</code>
     */
    public Builder clearMaximum() {
      
      maximum_ = 0D;
      onChanged();
      return this;
    }

    private double sumOfSquaredDeviation_ ;
    /**
     * <pre>
     * The sum of squared deviations from the mean:
     *   Sum[i=1..count]((x_i - mean)^2)
     * where each x_i is a sample values. If `count` is zero then this field
     * must be zero, otherwise validation of the request fails.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 5;</code>
     */
    public double getSumOfSquaredDeviation() {
      return sumOfSquaredDeviation_;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean:
     *   Sum[i=1..count]((x_i - mean)^2)
     * where each x_i is a sample values. If `count` is zero then this field
     * must be zero, otherwise validation of the request fails.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 5;</code>
     */
    public Builder setSumOfSquaredDeviation(double value) {
      
      sumOfSquaredDeviation_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean:
     *   Sum[i=1..count]((x_i - mean)^2)
     * where each x_i is a sample values. If `count` is zero then this field
     * must be zero, otherwise validation of the request fails.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 5;</code>
     */
    public Builder clearSumOfSquaredDeviation() {
      
      sumOfSquaredDeviation_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Long> bucketCounts_ = java.util.Collections.emptyList();
    private void ensureBucketCountsIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = new java.util.ArrayList<java.lang.Long>(bucketCounts_);
        bitField0_ |= 0x00000020;
       }
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public java.util.List<java.lang.Long>
        getBucketCountsList() {
      return java.util.Collections.unmodifiableList(bucketCounts_);
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public int getBucketCountsCount() {
      return bucketCounts_.size();
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public long getBucketCounts(int index) {
      return bucketCounts_.get(index);
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public Builder setBucketCounts(
        int index, long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public Builder addBucketCounts(long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public Builder addAllBucketCounts(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureBucketCountsIsMutable();
      my.com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, bucketCounts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of samples in each histogram bucket. `bucket_counts` are
     * optional. If present, they must sum to the `count` value.
     * The buckets are defined below in `bucket_option`. There are N buckets.
     * `bucket_counts[0]` is the number of samples in the underflow bucket.
     * `bucket_counts[1]` to `bucket_counts[N-1]` are the numbers of samples
     * in each of the finite buckets. And `bucket_counts[N] is the number
     * of samples in the overflow bucket. See the comments of `bucket_option`
     * below for more details.
     * Any suffix of trailing zeros may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 6;</code>
     */
    public Builder clearBucketCounts() {
      bucketCounts_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets, my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder> linearBucketsBuilder_;
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets getLinearBuckets() {
      if (linearBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 7) {
          return (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
      } else {
        if (bucketOptionCase_ == 7) {
          return linearBucketsBuilder_.getMessage();
        }
        return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public Builder setLinearBuckets(my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets value) {
      if (linearBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOption_ = value;
        onChanged();
      } else {
        linearBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public Builder setLinearBuckets(
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder builderForValue) {
      if (linearBucketsBuilder_ == null) {
        bucketOption_ = builderForValue.build();
        onChanged();
      } else {
        linearBucketsBuilder_.setMessage(builderForValue.build());
      }
      bucketOptionCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public Builder mergeLinearBuckets(my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets value) {
      if (linearBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 7 &&
            bucketOption_ != my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance()) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.newBuilder((my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_)
              .mergeFrom(value).buildPartial();
        } else {
          bucketOption_ = value;
        }
        onChanged();
      } else {
        if (bucketOptionCase_ == 7) {
          linearBucketsBuilder_.mergeFrom(value);
        }
        linearBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public Builder clearLinearBuckets() {
      if (linearBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 7) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
          onChanged();
        }
      } else {
        if (bucketOptionCase_ == 7) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
        }
        linearBucketsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder getLinearBucketsBuilder() {
      return getLinearBucketsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder getLinearBucketsOrBuilder() {
      if ((bucketOptionCase_ == 7) && (linearBucketsBuilder_ != null)) {
        return linearBucketsBuilder_.getMessageOrBuilder();
      } else {
        if (bucketOptionCase_ == 7) {
          return (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with constant width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.LinearBuckets linear_buckets = 7;</code>
     */
    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets, my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder>
        getLinearBucketsFieldBuilder() {
      if (linearBucketsBuilder_ == null) {
        if (!(bucketOptionCase_ == 7)) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.getDefaultInstance();
        }
        linearBucketsBuilder_ = new my.com.google.protobuf.SingleFieldBuilderV3<
            my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets, my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.LinearBucketsOrBuilder>(
                (my.com.google.api.servicecontrol.v1.Distribution.LinearBuckets) bucketOption_,
                getParentForChildren(),
                isClean());
        bucketOption_ = null;
      }
      bucketOptionCase_ = 7;
      onChanged();;
      return linearBucketsBuilder_;
    }

    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder> exponentialBucketsBuilder_;
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets getExponentialBuckets() {
      if (exponentialBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 8) {
          return (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
      } else {
        if (bucketOptionCase_ == 8) {
          return exponentialBucketsBuilder_.getMessage();
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public Builder setExponentialBuckets(my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets value) {
      if (exponentialBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOption_ = value;
        onChanged();
      } else {
        exponentialBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public Builder setExponentialBuckets(
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder builderForValue) {
      if (exponentialBucketsBuilder_ == null) {
        bucketOption_ = builderForValue.build();
        onChanged();
      } else {
        exponentialBucketsBuilder_.setMessage(builderForValue.build());
      }
      bucketOptionCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public Builder mergeExponentialBuckets(my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets value) {
      if (exponentialBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 8 &&
            bucketOption_ != my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance()) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.newBuilder((my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_)
              .mergeFrom(value).buildPartial();
        } else {
          bucketOption_ = value;
        }
        onChanged();
      } else {
        if (bucketOptionCase_ == 8) {
          exponentialBucketsBuilder_.mergeFrom(value);
        }
        exponentialBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public Builder clearExponentialBuckets() {
      if (exponentialBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 8) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
          onChanged();
        }
      } else {
        if (bucketOptionCase_ == 8) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
        }
        exponentialBucketsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder getExponentialBucketsBuilder() {
      return getExponentialBucketsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder getExponentialBucketsOrBuilder() {
      if ((bucketOptionCase_ == 8) && (exponentialBucketsBuilder_ != null)) {
        return exponentialBucketsBuilder_.getMessageOrBuilder();
      } else {
        if (bucketOptionCase_ == 8) {
          return (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with exponentially growing width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExponentialBuckets exponential_buckets = 8;</code>
     */
    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder>
        getExponentialBucketsFieldBuilder() {
      if (exponentialBucketsBuilder_ == null) {
        if (!(bucketOptionCase_ == 8)) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.getDefaultInstance();
        }
        exponentialBucketsBuilder_ = new my.com.google.protobuf.SingleFieldBuilderV3<
            my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExponentialBucketsOrBuilder>(
                (my.com.google.api.servicecontrol.v1.Distribution.ExponentialBuckets) bucketOption_,
                getParentForChildren(),
                isClean());
        bucketOption_ = null;
      }
      bucketOptionCase_ = 8;
      onChanged();;
      return exponentialBucketsBuilder_;
    }

    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder> explicitBucketsBuilder_;
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets getExplicitBuckets() {
      if (explicitBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 9) {
          return (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
      } else {
        if (bucketOptionCase_ == 9) {
          return explicitBucketsBuilder_.getMessage();
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public Builder setExplicitBuckets(my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets value) {
      if (explicitBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOption_ = value;
        onChanged();
      } else {
        explicitBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public Builder setExplicitBuckets(
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder builderForValue) {
      if (explicitBucketsBuilder_ == null) {
        bucketOption_ = builderForValue.build();
        onChanged();
      } else {
        explicitBucketsBuilder_.setMessage(builderForValue.build());
      }
      bucketOptionCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public Builder mergeExplicitBuckets(my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets value) {
      if (explicitBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 9 &&
            bucketOption_ != my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance()) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.newBuilder((my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_)
              .mergeFrom(value).buildPartial();
        } else {
          bucketOption_ = value;
        }
        onChanged();
      } else {
        if (bucketOptionCase_ == 9) {
          explicitBucketsBuilder_.mergeFrom(value);
        }
        explicitBucketsBuilder_.setMessage(value);
      }
      bucketOptionCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public Builder clearExplicitBuckets() {
      if (explicitBucketsBuilder_ == null) {
        if (bucketOptionCase_ == 9) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
          onChanged();
        }
      } else {
        if (bucketOptionCase_ == 9) {
          bucketOptionCase_ = 0;
          bucketOption_ = null;
        }
        explicitBucketsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder getExplicitBucketsBuilder() {
      return getExplicitBucketsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    public my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder getExplicitBucketsOrBuilder() {
      if ((bucketOptionCase_ == 9) && (explicitBucketsBuilder_ != null)) {
        return explicitBucketsBuilder_.getMessageOrBuilder();
      } else {
        if (bucketOptionCase_ == 9) {
          return (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_;
        }
        return my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Buckets with arbitrary user-provided width.
     * </pre>
     *
     * <code>.google.api.servicecontrol.v1.Distribution.ExplicitBuckets explicit_buckets = 9;</code>
     */
    private my.com.google.protobuf.SingleFieldBuilderV3<
        my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder>
        getExplicitBucketsFieldBuilder() {
      if (explicitBucketsBuilder_ == null) {
        if (!(bucketOptionCase_ == 9)) {
          bucketOption_ = my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.getDefaultInstance();
        }
        explicitBucketsBuilder_ = new my.com.google.protobuf.SingleFieldBuilderV3<
            my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets.Builder, my.com.google.api.servicecontrol.v1.Distribution.ExplicitBucketsOrBuilder>(
                (my.com.google.api.servicecontrol.v1.Distribution.ExplicitBuckets) bucketOption_,
                getParentForChildren(),
                isClean());
        bucketOption_ = null;
      }
      bucketOptionCase_ = 9;
      onChanged();;
      return explicitBucketsBuilder_;
    }
    public final Builder setUnknownFields(
        final my.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final my.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v1.Distribution)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v1.Distribution)
  private static final my.com.google.api.servicecontrol.v1.Distribution DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new my.com.google.api.servicecontrol.v1.Distribution();
  }

  public static my.com.google.api.servicecontrol.v1.Distribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final my.com.google.protobuf.Parser<Distribution>
      PARSER = new my.com.google.protobuf.AbstractParser<Distribution>() {
    public Distribution parsePartialFrom(
        my.com.google.protobuf.CodedInputStream input,
        my.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws my.com.google.protobuf.InvalidProtocolBufferException {
        return new Distribution(input, extensionRegistry);
    }
  };

  public static my.com.google.protobuf.Parser<Distribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public my.com.google.protobuf.Parser<Distribution> getParserForType() {
    return PARSER;
  }

  public my.com.google.api.servicecontrol.v1.Distribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

