package my.util;


import org.tensorflow.SavedModelBundle;
import org.tensorflow.framework.MetaGraphDef2;
import org.tensorflow.framework.SignatureDef2;

public class TensorflowUtils2 {
    public static SavedModelBundle loadModel(String modelpath) {
        SavedModelBundle bundle = SavedModelBundle.load(modelpath, "serve");
        return bundle;
    }

    public static SavedModelBundle loadModel(String modelpath, String version) {

        SavedModelBundle bundle = SavedModelBundle.load(modelpath + version, "serve");
        return bundle;
    }

    public static String getOutputName(String output, SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
        SignatureDef2 sig = MetaGraphDef2.parseFrom(bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);

        String outputName = sig.getOutputsMap().get(output).getName();

        return outputName;
    }

    public static String getInputName(String input, SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
//        System.out.println(bundle.metaGraphDef());
        SignatureDef2 sig = MetaGraphDef2.parseFrom(bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);


        String inputName = sig.getInputsMap().get(input).getName();

        return inputName;
    }

}
