/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.activity.RemoteAnticheatLotteryCheckService;
import cn.com.duiba.anticheat.center.api.result.activity.ALCResultDto;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryBlackConsumerStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryLessOneSecStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryNotMobileStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameDeapStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameUaCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryTongDunHighStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryWhiteIpStrategy;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteAnticheatLotteryCheckService")
public class RemoteAnticheatLotteryCheckServiceImpl
implements InitializingBean,
RemoteAnticheatLotteryCheckService {
    private static Logger log = LoggerFactory.getLogger(RemoteAnticheatLotteryCheckServiceImpl.class);
    private List<AnticheatLotteryStrategy> blackStrategies = new ArrayList<AnticheatLotteryStrategy>();
    private List<AnticheatLotteryStrategy> whiteStrategies = new ArrayList<AnticheatLotteryStrategy>();
    @Autowired
    private AnticheatLotteryLessOneSecStrategy anticheatLotteryLessOneSecStrategy;
    @Autowired
    private AnticheatLotterySameDeapStrategy anticheatLotterySameDeapStrategy;
    @Autowired
    private AnticheatLotterySameIpStrategy anticheatLotterySameIpStrategy;
    @Autowired
    private AnticheatLotteryBlackConsumerStrategy anticheatLotteryBlackConsumerStrategy;
    @Autowired
    private AnticheatLotteryNotMobileStrategy anticheatLotteryNotMobileStrategy;
    @Autowired
    private AnticheatLotterySameUaCreditsStrategy anticheatLotterySameUaCreditsStrategy;
    @Autowired
    private AnticheatLotteryTongDunHighStrategy anticheatLotteryTongDunHighStrategy;
    @Autowired
    private AnticheatLotteryWhiteIpStrategy anticheatLotteryWhiteIpStrategy;

    public DubboResult<ALCResultDto> checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        try {
            FraudApiResponse response = TongdunClient.checkLotteryTongdun(consumer, order, request);
            TongdunThreadLocal.get().setApiResponse(response);
            ALCResultDto result = this.innerCheckLottery(consumer, order, request);
            log.info("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, lotteryOrderId={}, type={}, appId={}, consumerId={}, result={}", new Object[]{order.getLotteryOrderId(), order.getType().desc(), consumer.getAppId(), consumer.getConsumerId(), result});
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, lotteryOrderId={}, type={}, appId={}, consumerId={}, message={}.", new Object[]{order.getLotteryOrderId(), order.getType().desc(), consumer.getAppId(), consumer.getConsumerId(), e.getMessage()});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private ALCResultDto innerCheckLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryStrategy.AnticheatLotteryStrategyResult ret;
        for (AnticheatLotteryStrategy as : this.whiteStrategies) {
            ret = as.checkLottery(consumer, order, request);
            if (!ret.isMatch() || !as.isEnable()) continue;
            return new ALCResultDto(Boolean.valueOf(true), "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        for (AnticheatLotteryStrategy as : this.blackStrategies) {
            ret = as.checkLottery(consumer, order, request);
            if (!ret.isMatch() || !as.isEnable() || as.getEffectMode() == 0 && !as.isAppEnable(consumer.getAppId())) continue;
            return new ALCResultDto(Boolean.valueOf(false), "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        return new ALCResultDto(Boolean.valueOf(true), null);
    }

    public void afterPropertiesSet() throws Exception {
        this.blackStrategies.add(this.anticheatLotteryLessOneSecStrategy);
        this.blackStrategies.add(this.anticheatLotterySameDeapStrategy);
        this.blackStrategies.add(this.anticheatLotteryBlackConsumerStrategy);
        this.blackStrategies.add(this.anticheatLotterySameIpStrategy);
        this.blackStrategies.add(this.anticheatLotteryNotMobileStrategy);
        this.blackStrategies.add(this.anticheatLotterySameUaCreditsStrategy);
        this.blackStrategies.add(this.anticheatLotteryTongDunHighStrategy);
        this.whiteStrategies.add(this.anticheatLotteryWhiteIpStrategy);
    }
}

