/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDAO;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotteryLessOneSecStrategy
implements AnticheatLotteryStrategy {
    private static final Map<Long, Long> lessOneSecMap = new ConcurrentHashMap<Long, Long>();
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDAO anticheatLotteryDebugLogDAO;

    public static void clearMap() {
        lessOneSecMap.clear();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("less-one-sec").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("less-one-sec").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("less-one-sec");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        Long consumerId = consumer.getConsumerId();
        Long preTimestamp = lessOneSecMap.get(consumerId);
        Date now = new Date();
        lessOneSecMap.put(consumerId, now.getTime());
        if (preTimestamp != null && now.getTime() - preTimestamp < 1000L) {
            Long debugId = this.doMatchProcess(consumer, order, request);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("less-one-sec");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,consumer=" + consumer.getConsumerId());
        this.anticheatLotteryDebugLogDAO.insert(debug);
        return debug.getId();
    }
}

