/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDAO;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotterySameIpStrategy
implements AnticheatLotteryStrategy {
    private static final HashMultimap<String, LotteryRecord> sameIpMap = HashMultimap.create();
    private static final int CONSUMER_IP_LIMIT_COUNT = 4;
    private static final int MAP_SIZE = 10000;
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDAO anticheatLotteryDebugLogDAO;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-ip").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-ip").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("same-ip");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        LotteryRecord record = new LotteryRecord();
        record.setIp(request.getIp());
        record.setOperatingActivityId(order.getOperatingActivityId());
        record.setDuibaActivityId(order.getDuibaActivityId());
        record.setTime(new Date());
        record.setType(order.getType());
        record.setLotteryOrderId(order.getLotteryOrderId());
        record.setConsumerId(consumer.getConsumerId());
        record.setAppId(consumer.getAppId());
        String key = AnticheatLotterySameIpStrategy.getKey(order.getOperatingActivityId(), request.getIp());
        if (sameIpMap.size() > 10000) {
            sameIpMap.clear();
        }
        sameIpMap.put((Object)key, (Object)record);
        Set records = sameIpMap.get((Object)key);
        if (records == null) {
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        if (records.size() > 4) {
            Long debugId = this.doMatchProcess(consumer, order, request, records.size());
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    private static String getKey(Long operatingActivityId, String ip) {
        return String.format("%s-%s", operatingActivityId, ip);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request, int count) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("same-ip");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(String.format("\ufffd\ufffd\ufffd IP(%s) \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd %s \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd %s \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(app\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid: %s, duiba\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid(\ufffd\ufffd\ufffdapp-\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid): %s)", request.getIp(), count, order.getType().desc(), order.getOperatingActivityId(), order.getDuibaActivityId()));
        this.anticheatLotteryDebugLogDAO.insert(debug);
        return debug.getId();
    }

    private class LotteryRecord {
        private LotteryOrderParams.LotteryOrderTypeEnum type;
        private Long operatingActivityId;
        private Long duibaActivityId;
        private Date time;
        private String ip;
        private Long lotteryOrderId;
        private Long consumerId;
        private Long appId;

        private LotteryRecord() {
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.consumerId});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LotteryRecord)) {
                return false;
            }
            LotteryRecord o = (LotteryRecord)obj;
            return this.consumerId.equals(o.consumerId);
        }

        public LotteryOrderParams.LotteryOrderTypeEnum getType() {
            return this.type;
        }

        public void setType(LotteryOrderParams.LotteryOrderTypeEnum type) {
            this.type = type;
        }

        public Long getOperatingActivityId() {
            return this.operatingActivityId;
        }

        public void setOperatingActivityId(Long operatingActivityId) {
            this.operatingActivityId = operatingActivityId;
        }

        public Long getDuibaActivityId() {
            return this.duibaActivityId;
        }

        public void setDuibaActivityId(Long duibaActivityId) {
            this.duibaActivityId = duibaActivityId;
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Long getLotteryOrderId() {
            return this.lotteryOrderId;
        }

        public void setLotteryOrderId(Long lotteryOrderId) {
            this.lotteryOrderId = lotteryOrderId;
        }

        public Long getConsumerId() {
            return this.consumerId;
        }

        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }
    }
}

