/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatBlackConsumerDAO;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDAO;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatBlackConsumerEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatBlackConsumerStrategy
implements AnticheatStrategy {
    @Autowired
    private AnticheatBlackConsumerDAO anticheatBlackConsumerDAO;
    @Autowired
    private AnticheatDebugLogDAO anticheatDebugLogDAO;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-consumer").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-consumer").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-consumer").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("black-consumer");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long consumerId = consumer.getConsumerId();
        AnticheatBlackConsumerEntity abc = this.anticheatBlackConsumerDAO.findByConsumerId(consumerId);
        if (abc == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        if (abc.getExpirationDate() == null || new Date().before(abc.getExpirationDate())) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("black-consumer");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ID (%s),\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", consumer.getConsumerId()));
        this.anticheatDebugLogDAO.insert(debug);
        return debug.getId();
    }
}

