/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDAO;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDAO;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.ConsumerFootprintEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.FootprintEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.anticheat.center.common.tools.DateUtil;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatFirstNoSwipeStrategy
implements AnticheatStrategy {
    private static Logger log = LoggerFactory.getLogger(AnticheatFirstNoSwipeStrategy.class);
    public static final int SwipeNotExist = 0;
    public static final int SwipeExist = 1;
    public static final int SwipeError = 2;
    public static final int SwipeSkip = 3;
    @Autowired
    private MemcachedClient memcachedClient;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDAO anticheatDebugLogDAO;
    @Autowired
    private ConsumerFootprintDAO consumerFootprintDAO;

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-no-swipe").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("first-no-swipe");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long consumerId = consumer.getConsumerId();
        Integer swipe = behavior.getSwipe();
        Long appId = consumer.getAppId();
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        if (this.isSwipeNotExist(swipe) && this.isFirstExchange(consumerId) && this.check(appId, gtype, gid)) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private boolean check(Long appId, Integer gtype, Long gid) {
        Integer ecCount;
        String key = this.getKey(appId, gtype, gid);
        int result = this.setByCas(key, 1);
        if (result == 2) {
            this.memcachedClient.add(key, DateUtil.getToTomorrowSeconds(), (Object)1);
        }
        if ((ecCount = (Integer)this.memcachedClient.get(key)) == null) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdmemcached\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + result);
            return false;
        }
        return ecCount >= 5;
    }

    private Integer setByCas(String key, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    ++nextValue;
                } else {
                    if (type >= 0) {
                        loop = false;
                        result = 4;
                        break;
                    }
                    --nextValue;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtil.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
        }
        return result;
    }

    private boolean isSwipeNotExist(Integer swipe) {
        return swipe != null && swipe.equals(0);
    }

    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = this.consumerFootprintDAO.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private String getKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-first-out-mins-appId-%s-gtype-%s-gid-%s", 103, appId, gtype, gid);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("first-no-swipe");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd id(%s),\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", consumer.getConsumerId()));
        this.anticheatDebugLogDAO.insert(debug);
        return debug.getId();
    }
}

