/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDAO;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDAO;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.ConsumerFootprintEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.FootprintEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatFirstSameUaCreditsStrategy
implements AnticheatStrategy {
    private static final int RANGE_VALUE = 20;
    private static final int MATCH_VALUE = 5;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDAO anticheatDebugLogDAO;
    @Autowired
    private ConsumerFootprintDAO consumerFootprintDAO;
    private Map<String, Queue<Model>> data = new HashMap<String, Queue<Model>>();

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("first-same-ua-credits");
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-same-ua-credits").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        boolean isFirst;
        Long credits;
        String ua;
        Long gid;
        Integer gtype;
        Long appId = consumer.getAppId();
        if (this.check(appId, gtype = goods.getGtype(), gid = goods.getGid(), ua = request.getUserAgent(), credits = consumer.getCredits(), isFirst = this.isFirstExchange(consumer.getConsumerId()))) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    public boolean check(Long appId, Integer gtype, Long gid, String ua, Long credits, boolean isFirst) {
        Model model = new Model();
        model.appId = appId;
        model.gtype = gtype;
        model.gid = gid;
        model.ua = ua;
        model.credits = credits;
        model.isFirst = isFirst;
        String datakey = this.getDataKey(model.appId, model.gtype, model.gid);
        Queue<Model> queue = this.data.get(datakey);
        if (queue == null) {
            queue = new LinkedBlockingQueue<Model>();
            this.data.put(datakey, queue);
        }
        queue.offer(model);
        while (queue.size() > 20) {
            queue.poll();
        }
        int count = 0;
        for (Model aQueue : queue) {
            if (!aQueue.equalsTo(model)) continue;
            ++count;
        }
        return count > 5;
    }

    private String getDataKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-%s-%s", appId, gtype, gid);
    }

    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = this.consumerFootprintDAO.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("first-same-ua-credits");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, app=%s, gtype=%s, gid=%s, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd=%s, UA=%s, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd20\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits(), request.getUserAgent()));
        this.anticheatDebugLogDAO.insert(debug);
        return debug.getId();
    }

    private class Model {
        public Long appId;
        public Integer gtype;
        public Long gid;
        public Long credits;
        public String ua;
        public boolean isFirst;

        private Model() {
        }

        public boolean equalsTo(Model obj) {
            return obj.appId.equals(this.appId) && obj.gtype.equals(this.gtype) && obj.gid.equals(this.gid) && obj.credits.equals(this.credits) && obj.ua != null && this.ua != null && obj.ua.equals(this.ua) && obj.isFirst == this.isFirst && this.isFirst;
        }
    }
}

