package cn.com.duiba.anticheat.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: RiskWhiteListDto
 * @Description:风控白名单
 * @date 2019/6/1821:27
 */
public class RiskWhiteListDto implements Serializable {


    private static final long serialVersionUID = 5788960684057069426L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 1 应用白名单，2 用户白名单
     */
    private Integer type;

    /**
     * 风控场景：1 提现，2 参与，3 发奖
     * isNotNull
     */
    private Integer riskSence;

    /**
     * 修改人
     */
    private String modifier;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 0 未删除，1已删除
     */
    private Integer deleted;

    /**
     * IP地址
     */
    private String ip;

    /**
     * 备注
     */
    private String remarks;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getRiskSence() {
        return riskSence;
    }

    public void setRiskSence(Integer riskSence) {
        this.riskSence = riskSence;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
