package cn.com.duiba.anticheat.center.api.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: ActRiskSenceEnum
 * @Description: 活动风控场景
 * @date 2019/6/1820:59
 * @see {http://cf.dui88.com/pages/viewpage.action?pageId=31930013}
 */
public enum ActRiskSenceEnum {
//1 访问；2活动参与；3奖励；4兑换；5提现；6发奖；7助力
    WITH_DRAW(1,"提现"),
    PARTICIPATION(2,"参与"),
    PRIZE(3,"发奖"),
    EXCHANGE(4,"兑换"),
    ASSIST(7,"助力");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    ActRiskSenceEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static ActRiskSenceEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (ActRiskSenceEnum rse: ActRiskSenceEnum.values()) {
            if(Objects.equals(rse.getValue(),value)){
                return rse;
            }
        }
        return null;
    }
}
