package cn.com.duiba.anticheat.center.api.enums;

import java.util.Objects;

/**
 * @author fengjun
 * @Title: RiskBlackListTypeEnum
 * @Description: 黑名单类型枚举
 * @date 2020-06-29
 * @email fengjun@duiba.com.cn
 */
public enum RiskBlackListTypeEnum {

    CONSUMER(1,"用户黑名单"),
    IP(2,"IP黑名单");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    RiskBlackListTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RiskBlackListTypeEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (RiskBlackListTypeEnum rse: RiskBlackListTypeEnum.values()) {
            if(Objects.equals(rse.getValue(),value)){
                return rse;
            }
        }
        return null;
    }

}
