package cn.com.duiba.anticheat.center.api.remoteservice.activity;

import cn.com.duiba.anticheat.center.api.param.ActivityBlackListInsertParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author XuJing
 * @since 2020/4/10 3:26 下午
 */
@AdvancedFeignClient
public interface RemoteActivityBlackListService {
    /**
     * 新增活动黑名单返回id
     *
     * @param record
     * @return
     */
    Long insert(ActivityBlackListInsertParam record) throws BizException;


    /**
     * 根据customerId查询
     *
     * @param customerId
     * @return
     */
    Boolean findByCustomerId(Long customerId) throws BizException;

    /**
     * 根据customerId删除用户 返回id
     *
     * @param customerId
     * @return
     */
    Long deleteByCustomerId(Long customerId) throws BizException;
}
