package cn.com.duiba.anticheat.center.api.remoteservice.risk;

import cn.com.duiba.anticheat.center.api.dto.RiskWhiteListDto;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author JunAngLiu
 * @Title: RemoteRiskWhiteListService
 * @Description: 风控白名单
 * @date 2019/6/1821:25
 */
@AdvancedFeignClient
public interface RemoteRiskWhiteListService {


    //新增
    int insert(RiskWhiteListDto dto)throws BizException;


    //根据主键修改
    int updateById(RiskWhiteListDto dto);

    /**
     * 条件查询list
     * @param param
     * @return
     */
    Page<RiskWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param);


    /**
     * 新白名单匹配接口
     * @param riksWhitelistMatchingParam 请求参数类
     * @return 是否匹配到白名单 True/False
     */
    Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam)throws BizException;
}
