/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.log;

import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TongdunLog {
    private static Logger logger = LoggerFactory.getLogger(TongdunLog.class);

    private TongdunLog() {
    }

    public static void log(Long consumerId, Long appId, Long operatingActivityId, Integer activityType, Long gid, Integer gtype, String ip, String ua, String eventId, String sessionId, FraudApiResponse fraudApiResponse, long startTime, long replyTime) {
        try {
            if (fraudApiResponse == null) {
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info(TongdunLog.logFormat(consumerId, appId, operatingActivityId, activityType, gid, gtype, ip, ua, eventId, sessionId, fraudApiResponse, startTime, replyTime));
            }
        }
        catch (Exception e) {
            logger.error("TongdunLog \u5931\u8d25", (Throwable)e);
        }
    }

    private static String logFormat(Long consumerId, Long appId, Long operatingActivityId, Integer activityType, Long gid, Integer gtype, String ip, String ua, String eventId, String sessionId, FraudApiResponse fraudApiResponse, long startTime, long replyTime) {
        JSONObject object = new JSONObject();
        Map<String, String> geoipInfo = fraudApiResponse.getGeoipInfo();
        Map<String, Object> deviceInfo = fraudApiResponse.getDeviceInfo();
        object.put("consumer_id", (Object)consumerId);
        object.put("app_id", (Object)appId);
        object.put("operating_activity_id", (Object)operatingActivityId);
        object.put("activity_type", (Object)activityType);
        object.put("g_id", (Object)gid);
        object.put("g_type", (Object)gtype);
        object.put("ip", (Object)ip);
        object.put("ua", (Object)ua);
        object.put("event_id", (Object)eventId);
        object.put("session_id", (Object)sessionId);
        object.put("final_score", (Object)fraudApiResponse.getFinalScore());
        object.put("final_decision", (Object)fraudApiResponse.getFinalDecision());
        object.put("policy_name", (Object)fraudApiResponse.getPolicyName());
        object.put("hit_rules", fraudApiResponse.getHitRules());
        object.put("seq_id", (Object)fraudApiResponse.getSeqId());
        object.put("spend_time", (Object)fraudApiResponse.getSpendTime());
        object.put("city", (Object)geoipInfo.get("city"));
        object.put("province", (Object)geoipInfo.get("province"));
        object.put("deviceType", deviceInfo.get("deviceType"));
        object.put("deviceId", deviceInfo.get("deviceId"));
        object.put("tonkenId", deviceInfo.get("tonkenId"));
        object.put("smartId", deviceInfo.get("smartId"));
        object.put("canvas", deviceInfo.get("canvas"));
        object.put("start_time", (Object)startTime);
        object.put("reply_time", (Object)replyTime);
        object.put("logTime", (Object)DateUtils.getSecondStr((Date)new Date()));
        return object.toJSONString();
    }
}

