/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.activity.impl;

import cn.com.duiba.anticheat.center.api.constant.StaticListConstant;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.activity.RemoteAnticheatLotteryCheckService;
import cn.com.duiba.anticheat.center.api.result.activity.ALCResultDto;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryBlackConsumerStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryLessOneSecStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryNotMobileStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameDeapStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameUaCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryTongDunHighStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryWhiteAppStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryWhiteIpStrategy;
import cn.com.duiba.anticheat.center.common.tool.ThreadTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="remoteAnticheatLotteryCheckService")
public class RemoteAnticheatLotteryCheckServiceImpl
implements InitializingBean,
RemoteAnticheatLotteryCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatLotteryCheckServiceImpl.class);
    @Autowired
    private AnticheatLotteryLessOneSecStrategy anticheatLotteryLessOneSecStrategy;
    @Autowired
    private AnticheatLotterySameDeapStrategy anticheatLotterySameDeapStrategy;
    @Autowired
    private AnticheatLotterySameIpStrategy anticheatLotterySameIpStrategy;
    @Autowired
    private AnticheatLotteryBlackConsumerStrategy anticheatLotteryBlackConsumerStrategy;
    @Autowired
    private AnticheatLotteryNotMobileStrategy anticheatLotteryNotMobileStrategy;
    @Autowired
    private AnticheatLotterySameUaCreditsStrategy anticheatLotterySameUaCreditsStrategy;
    @Autowired
    private AnticheatLotteryTongDunHighStrategy anticheatLotteryTongDunHighStrategy;
    @Autowired
    private AnticheatLotteryWhiteIpStrategy anticheatLotteryWhiteIpStrategy;
    @Autowired
    private AnticheatLotteryWhiteAppStrategy anticheatLotteryWhiteAppStrategy;
    @Resource
    private ExecutorService executorService;
    private static final int TIMEOUT_TIME = 80;
    private static final Semaphore SEMAPHORE = new Semaphore(100);
    private List<AnticheatLotteryStrategy> tongDunStrategies = new ArrayList<AnticheatLotteryStrategy>();
    private List<AnticheatLotteryStrategy> blackStrategies = new ArrayList<AnticheatLotteryStrategy>();
    private List<AnticheatLotteryStrategy> whiteStrategies = new ArrayList<AnticheatLotteryStrategy>();

    public void afterPropertiesSet() throws Exception {
        this.tongDunStrategies.add(this.anticheatLotteryTongDunHighStrategy);
        this.blackStrategies.add(this.anticheatLotteryLessOneSecStrategy);
        this.blackStrategies.add(this.anticheatLotterySameDeapStrategy);
        this.blackStrategies.add(this.anticheatLotteryBlackConsumerStrategy);
        this.blackStrategies.add(this.anticheatLotterySameIpStrategy);
        this.blackStrategies.add(this.anticheatLotteryNotMobileStrategy);
        this.blackStrategies.add(this.anticheatLotterySameUaCreditsStrategy);
        this.whiteStrategies.add(this.anticheatLotteryWhiteAppStrategy);
        this.whiteStrategies.add(this.anticheatLotteryWhiteIpStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<ALCResultDto> checkLottery(final LotteryConsumerParams consumer, final LotteryOrderParams order, final LotteryRequestParams request) {
        if (StaticListConstant.matchWhiteApp((Long)consumer.getAppId())) {
            return DubboResult.successResult((Object)new ALCResultDto(Boolean.valueOf(true), null));
        }
        Callable<DubboResult<ALCResultDto>> callable = new Callable<DubboResult<ALCResultDto>>(){

            @Override
            public DubboResult<ALCResultDto> call() throws Exception {
                ALCResultDto result = RemoteAnticheatLotteryCheckServiceImpl.this.innerCheckLottery(consumer, order, request);
                return DubboResult.successResult((Object)result);
            }
        };
        DubboResult successResult = DubboResult.successResult((Object)new ALCResultDto(Boolean.valueOf(true), null));
        if (SEMAPHORE.tryAcquire()) {
            Future<DubboResult<ALCResultDto>> future = null;
            try {
                future = this.executorService.submit(callable);
                DubboResult result = future.get(80L, TimeUnit.MILLISECONDS);
                DubboResult dubboResult = result != null ? result : successResult;
                return dubboResult;
            }
            catch (TimeoutException e) {
                LOGGER.info("\u62bd\u5956\u9632\u4f5c\u5f0a\u964d\u7ea7,\u4e1a\u52a1\u8d85\u65f6, errMsg={}", (Object)e.getMessage());
                LOGGER.debug("\u62bd\u5956\u9632\u4f5c\u5f0a\u964d\u7ea7,\u4e1a\u52a1\u8d85\u65f6", (Throwable)e);
                ThreadTool.cancelTask(future);
                DubboResult dubboResult = successResult;
                return dubboResult;
            }
            catch (Exception e) {
                LOGGER.warn("\u62bd\u5956\u9632\u4f5c\u5f0a\u964d\u7ea7,\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ThreadTool.cancelTask(future);
                DubboResult dubboResult = successResult;
                return dubboResult;
            }
            finally {
                SEMAPHORE.release();
            }
        }
        LOGGER.info("\u62bd\u5956\u9632\u4f5c\u5f0a\u964d\u7ea7\u901a\u8fc7,\u6d41\u91cf\u8d85\u4e86, lotteryOrderId={}, type={}, appId={}, consumerId={}", new Object[]{order.getLotteryOrderId(), order.getType().desc(), consumer.getAppId(), consumer.getConsumerId()});
        return successResult;
    }

    private ALCResultDto innerCheckLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        ALCResultDto ret = null;
        ret = this.whiteStrategyMatch(consumer, order, request);
        if (ret != null) {
            return ret;
        }
        ret = this.blackStrategyMatch(consumer, order, request, this.blackStrategies);
        if (ret != null) {
            return ret;
        }
        ret = this.tongDunStrategyMatch(consumer, order, request);
        if (ret != null) {
            return ret;
        }
        return new ALCResultDto(Boolean.valueOf(true), null);
    }

    private ALCResultDto whiteStrategyMatch(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        for (AnticheatLotteryStrategy as : this.whiteStrategies) {
            Transaction t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                AnticheatLotteryStrategy.AnticheatLotteryStrategyResult ret = as.checkLotteryFast(consumer, order, request);
                t.setStatus("0");
                if (!this.judgeMatch(ret, as, consumer)) continue;
                ALCResultDto aLCResultDto = new ALCResultDto(Boolean.valueOf(true), "\u901a\u8fc7\u9a8c\u8bc1");
                return aLCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    private ALCResultDto tongDunStrategyMatch(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        ArrayList<AnticheatLotteryStrategy> targetStrategies = new ArrayList<AnticheatLotteryStrategy>();
        for (AnticheatLotteryStrategy strategy : this.tongDunStrategies) {
            if (!strategy.needValid(consumer)) continue;
            targetStrategies.add(strategy);
        }
        if (targetStrategies.isEmpty()) {
            return null;
        }
        FraudApiResponse response = TongdunClient.checkLotteryTongdun(consumer, order, request);
        TongdunThreadLocal.get().setApiResponse(response);
        return this.blackStrategyMatch(consumer, order, request, targetStrategies);
    }

    private ALCResultDto blackStrategyMatch(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request, List<AnticheatLotteryStrategy> strategies) {
        for (AnticheatLotteryStrategy as : strategies) {
            Transaction t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                AnticheatLotteryStrategy.AnticheatLotteryStrategyResult ret = as.checkLotteryFast(consumer, order, request);
                t.setStatus("0");
                if (!this.judgeMatch(ret, as, consumer)) continue;
                ALCResultDto aLCResultDto = new ALCResultDto(Boolean.valueOf(false), "\u62bd\u5956\u9632\u4f5c\u5f0a\u7b56\u7565");
                return aLCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    private boolean judgeMatch(AnticheatLotteryStrategy.AnticheatLotteryStrategyResult ret, AnticheatLotteryStrategy as, LotteryConsumerParams consumer) {
        if (!ret.isMatch()) {
            return false;
        }
        return as.needValid(consumer);
    }
}

