/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.scheduler;

import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl.RemoteAnticheatAlarmServiceImpl;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmScheduler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmScheduler.class);
    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;
    @Autowired
    private SmsRemindService smsRemindService;
    @Resource
    private ScheduledExecutorService scheduledExecutorService;

    public void afterPropertiesSet() throws Exception {
        this.alarmScheduler();
    }

    private void alarmScheduler() {
        final AnticheatAlarmConfigEntity config = this.anticheatAlarmConfigService.getCacheConfig("app-item-alarm");
        final int circle = config.getCircle();
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                int threshold = config.getThreshold();
                for (Map.Entry<String, Integer> entry : RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().entrySet()) {
                    if (entry.getValue() < threshold) continue;
                    String[] args = entry.getKey().split("-");
                    String message = "\u9632\u4f5c\u5f0a\u9884\u8b66\uff1aappId=" + args[0] + ", itemId=" + args[1] + ", \u53d1\u751f\u65f6\u95f4=" + DateUtils.getSecondStr((Date)new Date()) + ", " + circle + "\u5206\u949f\u5151\u6362\u4f18\u60e0\u5238\u6570\u91cf=" + entry.getValue();
                    try {
                        AlarmScheduler.this.smsRemindService.alarm(config.getPhone(), message);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u9632\u4f5c\u5f0a\u9884\u8b66\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38," + message, (Throwable)e);
                    }
                }
                RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().clear();
            }
        }, 0L, circle, TimeUnit.MINUTES);
    }
}

