/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameIpStrategy
implements AnticheatStrategy {
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    public static void clearMap() {
        couponExchangeMap.clear();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-ip").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-ip").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-ip").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("same-ip");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String ip;
        Long appId;
        Long gid;
        Integer gtype = goods.getGtype();
        String itemAppIpKey = this.getItemAppIpKey(gtype, gid = goods.getGid(), appId = consumer.getAppId(), ip = request.getIp());
        Integer value = couponExchangeMap.get(itemAppIpKey);
        if (value == null) {
            value = 1;
            couponExchangeMap.put(itemAppIpKey, value);
        } else {
            value = value + 1;
            couponExchangeMap.put(itemAppIpKey, value);
        }
        if (value > 5) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-ip");
        debug.setMessage(String.format("\u76f8\u540c appId: %s, gtype: %s, gid: %s, ip: %s \u7d2f\u8ba1\u5151\u6362\u8d85\u8fc75\u6b21", consumer.getAppId(), goods.getGtype(), goods.getGid(), request.getIp()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    private String getItemAppIpKey(Integer gtype, Long gid, Long appId, String ip) {
        return String.format("%s-%s-%s-%s", gtype, gid, appId, ip);
    }
}

