/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.handler;

import cn.com.duiba.anticheat.center.api.enums.ActivityPosEnum;
import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandler;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandlerRegister;
import cn.com.duiba.anticheat.center.biz.model.AlipayInfoModel;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleExcuteService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityAntiHandler
implements AntiSceneHandler {
    @Autowired
    private RuleExcuteService ruleExcuteService;

    @PostConstruct
    public void init() {
        AntiSceneHandlerRegister.registerHandler(this);
    }

    @Override
    public Integer getSceneType() {
        return RuleSceneEnum.ACTIVITY.getType();
    }

    public boolean isHitRule(DuibaBaseModel duibaModel) {
        DataServerHandler userIpNumIn1HourHandler;
        DataServerHandler dayInviteUserHandler;
        DataServerHandler dayIpWithUserHandler;
        DataServerHandler ipUserHandler;
        DataServerHandler ipMinAskHandler;
        DataServerHandler userIpUaHandler;
        DataServerHandler helpedMaxHandler;
        DataServerHandler ipTotalHelpedHandler;
        DataServerHandler beHelpedHandler;
        ArrayList models = Lists.newArrayList();
        DuibaActivityModel model = (DuibaActivityModel)duibaModel;
        models.add(model);
        DataServerHandler userIpHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP.getCode());
        if (userIpHandler != null) {
            model.setUserIpNum(userIpHandler.setAndGetService(model));
        }
        if ((beHelpedHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_BE_HELPED.getCode())) != null) {
            model.setBeHelpedNum(beHelpedHandler.getService(model));
        }
        if ((ipTotalHelpedHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED.getCode())) != null) {
            model.setIpTotalHelped(ipTotalHelpedHandler.getService(model));
        }
        if ((helpedMaxHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_MAX_IP_UA_HELPED.getCode())) != null) {
            model.setMaxIpUaHelped(helpedMaxHandler.getService(model));
        }
        if ((userIpUaHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_UA_CIDNUM.getCode())) != null) {
            model.setIpUaCidNum(userIpUaHandler.setAndGetService(model));
        }
        if ((ipMinAskHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_ASK.getCode())) != null) {
            model.setIpAskNum(ipMinAskHandler.setAndGetService(model));
        }
        if ((ipUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_USERNUM.getCode())) != null) {
            model.setIpUserNum(ipUserHandler.setAndGetService(model));
        }
        if ((dayIpWithUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.DAY_IP_USERNUM.getCode())) != null) {
            model.setDayIpUserNum(dayIpWithUserHandler.setAndGetService(model));
        }
        if ((dayInviteUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.DAY_INVITE_USERNUM.getCode())) != null) {
            model.setDayUserInviteNum(dayInviteUserHandler.getService(model));
        }
        if ((userIpNumIn1HourHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP_NUM_1HOUR.getCode())) != null) {
            model.setUserIpNumIn1Hour(userIpNumIn1HourHandler.setAndGetService(model));
        }
        DataServerHandler userIpUaIn1DayHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY.getCode());
        if (userIpUaHandler != null) {
            model.setIpUaCidNumIn1Day(userIpUaIn1DayHandler.setAndGetService(model));
        }
        if (ActivityPosEnum.TAKEPRIZE.equals((Object)model.getPosEnum())) {
            this.alipayCheck(models, model);
        }
        return this.ruleExcuteService.runRule(RuleSceneEnum.ACTIVITY, models);
    }

    private void alipayCheck(List<Object> models, DuibaActivityModel model) {
        DataServerHandler accountTimesIn1DayHandler;
        DataServerHandler accountWithUaTimesHandler;
        DataServerHandler nameUserHandler;
        DataServerHandler accountUserHandler;
        DataServerHandler nameHandler;
        AlipayInfoModel alipayInfoModel = new AlipayInfoModel();
        DataServerHandler accountHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT.getCode());
        if (accountHandler != null) {
            alipayInfoModel.setAccountTimes(accountHandler.setAndGetService(model));
        }
        if ((nameHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_NAME.getCode())) != null) {
            alipayInfoModel.setNameTimes(nameHandler.setAndGetService(model));
        }
        if ((accountUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_USER.getCode())) != null) {
            alipayInfoModel.setAccountWithCidTimes(accountUserHandler.setAndGetService(model));
        }
        if ((nameUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_NAME_USER.getCode())) != null) {
            alipayInfoModel.setNameWithCidTimes(nameUserHandler.setAndGetService(model));
        }
        if ((accountWithUaTimesHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES.getCode())) != null) {
            alipayInfoModel.setAccountWithUaTimes(accountWithUaTimesHandler.setAndGetService(model));
        }
        if ((accountTimesIn1DayHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_TIMES_1DAY.getCode())) != null) {
            alipayInfoModel.setAccountTimesIn1Day(accountTimesIn1DayHandler.setAndGetService(model));
        }
        models.add(alipayInfoModel);
    }
}

