/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.scheduler;

import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl.RemoteAnticheatAlarmServiceImpl;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmScheduler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmScheduler.class);
    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;
    @Autowired
    private SmsRemindService smsRemindService;
    @Resource
    private ScheduledExecutorService scheduledExecutorService;

    public void afterPropertiesSet() throws Exception {
        this.alarmScheduler();
    }

    private void alarmScheduler() {
        AnticheatAlarmConfigEntity config = this.anticheatAlarmConfigService.getCacheConfig("app-item-alarm");
        int circle = config.getCircle();
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            int threshold = config.getThreshold();
            for (Map.Entry<String, Integer> entry : RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().entrySet()) {
                if (entry.getValue() < threshold) continue;
                String[] args = entry.getKey().split("-");
                AlarmSmsParams alarmSmsParams = new AlarmSmsParams();
                alarmSmsParams.setAppId(Long.valueOf(args[0]));
                alarmSmsParams.setItemId(Long.valueOf(args[1]));
                alarmSmsParams.setCircle(Integer.valueOf(circle));
                alarmSmsParams.setDate(DateUtils.getSecondStr((Date)new Date()));
                alarmSmsParams.setValue(entry.getValue());
                try {
                    this.smsRemindService.alarm(config.getPhone(), alarmSmsParams);
                }
                catch (Exception e) {
                    LOGGER.error("\u9632\u4f5c\u5f0a\u9884\u8b66\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38, alarmSmsParams= [{}]", (Object)JSONObject.toJSONString((Object)alarmSmsParams), (Object)e);
                }
            }
            RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().clear();
        }, 0L, circle, TimeUnit.MINUTES);
    }
}

