/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service;

import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.message.service.api.dto.SmsSendInvoice;
import cn.com.duiba.message.service.api.enums.BizCodeEnum;
import cn.com.duiba.message.service.api.remoteservice.RemoteSmsService;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsRemindService {
    private static final Logger log = LoggerFactory.getLogger(SmsRemindService.class);
    @Autowired
    private RemoteSmsService remoteSmsService;

    public String sendAlarmSms(String phone, AlarmSmsParams alarmSmsParams) throws BizException {
        SmsSendInvoice sendResult = this.remoteSmsService.send(phone, MessageFormat.format("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u9632\u4f5c\u5f0a\u9884\u8b66\uff1aappId={0} \uff0c itemId={1} \uff0c \u53d1\u751f\u65f6\u95f4={2} \uff0c {3}\u5206\u949f\u5151\u6362\u4f18\u60e0\u5238\u6570\u91cf={4}\u3002", alarmSmsParams.getAppId(), alarmSmsParams.getItemId(), alarmSmsParams.getDate(), alarmSmsParams.getCircle(), alarmSmsParams.getValue()), BizCodeEnum.DUIBA.value());
        if (sendResult.getSuccess().booleanValue()) {
            return sendResult.getDbSmsId();
        }
        if (log.isWarnEnabled()) {
            log.warn("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25 phone= [{}],alarmSmsParams= [{}]", (Object)phone, (Object)JSONObject.toJSONString((Object)alarmSmsParams));
        }
        return null;
    }

    public void alarm(String phones, AlarmSmsParams alarmSmsParams) throws BizException {
        String[] users;
        for (String u : users = phones.split(",")) {
            if (StringUtils.isBlank((String)u)) continue;
            this.sendAlarmSms(u, alarmSmsParams);
        }
    }
}

