/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.hbase.impl;

import cn.com.duiba.anticheat.center.biz.entity.hbase.HbaseBatchPutEntity;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.common.tool.HbaseRowKeyTool;
import cn.com.duiba.boot.perftest.PerfTestContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;

@Service
public class DuibaHbaseRiskServiceImpl
implements DuibaHbaseRiskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaHbaseRiskServiceImpl.class);
    @Resource
    private HbaseTemplate hbaseTemplate;
    private static final String TABLE_NAME = "duiba_risk";
    private static final String PREF_TABLE_NAME = "pref_duiba_kv";
    private static final String FAMILY_NAME = "f1";
    private static final String LONG_COLUMN = "l1";

    @Override
    public Long increaseByKey(String rowKey, long incrNum) {
        String newRowKey = HbaseRowKeyTool.handleRowKey((String)rowKey);
        try {
            return (Long)this.hbaseTemplate.execute(this.getTableName(), htable -> {
                Charset charset = this.hbaseTemplate.getCharset();
                return htable.incrementColumnValue(newRowKey.getBytes(charset), FAMILY_NAME.getBytes(charset), LONG_COLUMN.getBytes(charset), incrNum);
            });
        }
        catch (Exception e) {
            LOGGER.warn("Hbase increaseByKey error,rowkey={}", (Object)rowKey, (Object)e);
            return null;
        }
    }

    @Override
    public void upsert(String rowKey, long num) {
        String newRowKey = HbaseRowKeyTool.handleRowKey((String)rowKey);
        this.hbaseTemplate.put(this.getTableName(), newRowKey, FAMILY_NAME, LONG_COLUMN, Bytes.toBytes((long)num));
    }

    @Override
    public void batchUpsert(List<HbaseBatchPutEntity> putEntityList) {
        this.hbaseTemplate.execute(this.getTableName(), htable -> {
            ArrayList<Put> puts = new ArrayList<Put>(putEntityList.size());
            Charset charset = this.hbaseTemplate.getCharset();
            for (HbaseBatchPutEntity entity : putEntityList) {
                String rowKey = HbaseRowKeyTool.handleRowKey((String)entity.getRowKey());
                long value = entity.getIncrNum();
                puts.add(new Put(rowKey.getBytes(charset)).addColumn(FAMILY_NAME.getBytes(charset), LONG_COLUMN.getBytes(charset), Bytes.toBytes((long)value)));
            }
            htable.put(puts);
            return true;
        });
    }

    @Override
    public Long findByRowKey(String rowKey) {
        String newRowKey = HbaseRowKeyTool.handleRowKey((String)rowKey);
        try {
            return (Long)this.hbaseTemplate.get(this.getTableName(), newRowKey, FAMILY_NAME, LONG_COLUMN, (result, rowNum) -> {
                if (result.isEmpty()) {
                    return null;
                }
                return Bytes.toLong((byte[])result.value());
            });
        }
        catch (Exception e) {
            LOGGER.warn("Hbase findByRowKey error,rowKey={}", (Object)newRowKey, (Object)e);
            return null;
        }
    }

    private String getTableName() {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return PREF_TABLE_NAME;
        }
        return TABLE_NAME;
    }
}

