/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class IpUaWithUserIn1DayHandler
implements DataServerHandler {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private SwitchService switchService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY;
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        String ip = model.getIp();
        String ua = model.getUa();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY) || consumerId == null || appId == null || activityId == null || StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)ua)) {
            return 0L;
        }
        String redisKey = RedisKeyFactory.K016.toString() + appId + "_" + activityId + "_" + ip + "_" + DigestUtils.md5Hex((String)ua);
        List results = this.stringRedisTemplate.executePipelined(connection -> {
            StringRedisConnection conn = (StringRedisConnection)connection;
            conn.sAdd(redisKey, new String[]{String.valueOf(consumerId)});
            conn.ttl(redisKey);
            conn.sCard(redisKey);
            return null;
        });
        Long ttl = (Long)results.get(1);
        Long count = (Long)results.get(2);
        if (ttl == -1L) {
            this.stringRedisTemplate.expireAt((Object)redisKey, DateTime.now().millisOfDay().withMaximumValue().toDate());
        }
        return count;
    }
}

