/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeDto;
import cn.com.duiba.anticheat.center.biz.dao.rules.RuleConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.rules.RuleConfigEntity;
import cn.com.duiba.anticheat.center.biz.enums.RuleStatusEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleChangeService;
import cn.com.duiba.anticheat.center.biz.service.rules.impl.KieComponent;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RuleChangeServiceImpl
implements RuleChangeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleChangeServiceImpl.class);
    @Autowired
    private RuleConfigDao ruleConfigDao;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String REDIS_BORDCAST_TOPIC = "kbaseChange";

    @Override
    public void delete(RuleSceneEnum scene, String ruleName) throws BizException {
        if (scene == null) {
            return;
        }
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            return;
        }
        Rule rule = kbase.getRule(scene.getPkg(), ruleName);
        if (rule == null) {
            throw new BizException("\u65e0\u6b64\u89c4\u5219");
        }
        this.ruleConfigDao.updateRuleByName(ruleName, RuleStatusEnum.CLOSE.getType());
        RuleChangeDto changeDto = new RuleChangeDto();
        changeDto.setOpType("delete");
        changeDto.setRuleName(ruleName);
        changeDto.setScene(scene);
        this.stringRedisTemplate.convertAndSend(REDIS_BORDCAST_TOPIC, (Object)JSONObject.toJSONString((Object)changeDto));
    }

    @Override
    public void add(RuleSceneEnum scene, String ruleContent, String ruleName) throws BizException {
        if (!this.basicCheck(scene, ruleContent, ruleName)) {
            return;
        }
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            return;
        }
        Rule rule = kbase.getRule(scene.getPkg(), ruleName);
        if (rule != null) {
            throw new BizException("\u5df2\u7ecf\u5b58\u5728\u6b64\u89c4\u5219");
        }
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kb.add(ResourceFactory.newByteArrayResource((byte[])ruleContent.getBytes("utf-8")), ResourceType.DRL);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89c4\u5219\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            throw new BizException("\u89c4\u5219\u8f6c\u6362\u4e8c\u8fdb\u5236\u5931\u8d25" + e.getMessage());
        }
        if (kb.hasErrors()) {
            throw new BizException("\u89c4\u5219\u7f16\u8bd1\u5931\u8d25" + kb.getErrors());
        }
        RuleConfigEntity entity = new RuleConfigEntity();
        entity.setRuleName(ruleName);
        entity.setRuleContent(ruleContent);
        entity.setRuleScene(scene.getType());
        entity.setRuleStatus(RuleStatusEnum.OPEN.getType());
        this.ruleConfigDao.insert(entity);
        RuleChangeDto changeDto = new RuleChangeDto();
        changeDto.setOpType("add");
        changeDto.setRuleName(ruleName);
        changeDto.setScene(scene);
        changeDto.setRuleContent(ruleContent);
        this.stringRedisTemplate.convertAndSend(REDIS_BORDCAST_TOPIC, (Object)JSONObject.toJSONString((Object)changeDto));
    }

    @Override
    public void update(RuleSceneEnum scene, String ruleContent, String ruleName) throws BizException {
        if (!this.basicCheck(scene, ruleContent, ruleName)) {
            return;
        }
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            return;
        }
        Rule rule = kbase.getRule(scene.getPkg(), ruleName);
        if (rule == null) {
            throw new BizException("\u65e0\u6b64\u89c4\u5219");
        }
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kb.add(ResourceFactory.newByteArrayResource((byte[])ruleContent.getBytes("utf-8")), ResourceType.DRL);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89c4\u5219\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            throw new BizException("\u89c4\u5219\u8f6c\u6362\u4e8c\u8fdb\u5236\u5931\u8d25" + e.getMessage());
        }
        if (kb.hasErrors()) {
            throw new BizException("\u89c4\u5219\u7f16\u8bd1\u5931\u8d25" + kb.getErrors());
        }
        RuleConfigEntity entity = new RuleConfigEntity();
        entity.setRuleName(ruleName);
        entity.setRuleContent(ruleContent);
        entity.setRuleScene(scene.getType());
        this.ruleConfigDao.update(entity);
        RuleChangeDto changeDto = new RuleChangeDto();
        changeDto.setOpType("update");
        changeDto.setRuleName(ruleName);
        changeDto.setScene(scene);
        changeDto.setRuleContent(ruleContent);
        this.stringRedisTemplate.convertAndSend(REDIS_BORDCAST_TOPIC, (Object)JSONObject.toJSONString((Object)changeDto));
    }

    @Override
    public Boolean refresh(RuleSceneEnum scene) {
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            throw new AnticheatException("\u627e\u4e0d\u5230\u573a\u666f\u5bf9\u5e94\u77e5\u8bc6\u5e93");
        }
        RuleChangeDto changeDto = new RuleChangeDto();
        changeDto.setOpType("refresh");
        changeDto.setScene(scene);
        this.stringRedisTemplate.convertAndSend(REDIS_BORDCAST_TOPIC, (Object)JSONObject.toJSONString((Object)changeDto));
        return Boolean.TRUE;
    }

    @Override
    public Boolean open(RuleSceneEnum scene, String ruleName) {
        KnowledgeBaseImpl kbase = (KnowledgeBaseImpl)KieComponent.getBaseByScene(scene.getType());
        if (kbase == null) {
            throw new AnticheatException("\u89c4\u5219\u77e5\u8bc6\u5e93\u4e0d\u5b58\u5728");
        }
        Rule rule = kbase.getRule(scene.getPkg(), ruleName);
        if (rule != null) {
            return Boolean.FALSE;
        }
        RuleConfigEntity entity = new RuleConfigEntity();
        entity.setRuleName(ruleName);
        entity.setRuleScene(scene.getType());
        entity.setRuleStatus(1);
        this.ruleConfigDao.update(entity);
        RuleChangeDto changeDto = new RuleChangeDto();
        changeDto.setOpType("open");
        changeDto.setRuleName(ruleName);
        changeDto.setScene(scene);
        this.stringRedisTemplate.convertAndSend(REDIS_BORDCAST_TOPIC, (Object)JSONObject.toJSONString((Object)changeDto));
        return Boolean.TRUE;
    }

    private boolean basicCheck(RuleSceneEnum scene, String ruleContent, String ruleName) {
        if (scene == null || StringUtils.isBlank((String)ruleContent) || StringUtils.isBlank((String)ruleName)) {
            return false;
        }
        return ruleContent.contains(ruleName) && ruleContent.contains(scene.getPkg());
    }
}

