/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameCreditsAddUpStrategy
implements AnticheatStrategy {
    private static Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    public static void clearMap() {
        couponExchangeMap.clear();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("same-credits-add-up");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long gid;
        Long appId = consumer.getAppId();
        Long credits = consumer.getCredits();
        Integer gtype = goods.getGtype();
        Integer value = couponExchangeMap.get(this.getItemAppCreditsKey(gtype, gid = goods.getGid(), appId, credits));
        if (value == null) {
            value = 1;
            couponExchangeMap.put(this.getItemAppCreditsKey(gtype, gid, appId, credits), value);
        } else {
            value = value + 1;
            couponExchangeMap.put(this.getItemAppCreditsKey(gtype, gid, appId, credits), value);
        }
        if (value > 5) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-credits-add-up");
        debug.setMessage(String.format("\u76f8\u540c appId: %s, gtype: %s, gid: %s, credits: %s, \u7d2f\u8ba1\u5151\u6362\u8d85\u8fc75\u6b21", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    private String getItemAppCreditsKey(Integer gtype, Long gid, Long appId, Long credits) {
        return String.format("%s-%s-%s-%s", gtype, gid, appId, credits);
    }
}

