package cn.com.duiba.anticheat.center.biz.dao.activity.impl;

import cn.com.duiba.anticheat.center.api.dto.ActivityBlackListDto;
import cn.com.duiba.anticheat.center.api.param.ActivityBlackListParam;
import cn.com.duiba.anticheat.center.biz.dao.BaseDao;
import cn.com.duiba.anticheat.center.biz.dao.DatabaseSchema;
import cn.com.duiba.anticheat.center.biz.dao.activity.ActivityBlackListDao;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.List;

@Repository
public class ActivityBlackListDaoImpl extends BaseDao implements ActivityBlackListDao {

    @PostConstruct
    private void init() {
        this.databaseSchema = DatabaseSchema.DEVELOPER_APP;
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return update("deleteByPrimaryKey", id);
    }

    @Override
    public int insert(ActivityBlackListDto record) {
        return insert("insert", record);
    }


    @Override
    public ActivityBlackListDto selectByPrimaryKey(Long id) {
        return selectOne("selectByPrimaryKey", id);
    }

    @Override
    public int updateByPrimaryKey(ActivityBlackListDto record) {
        return update("updateByPrimaryKey", record);
    }

    @Override
    public List<ActivityBlackListDto> listByCondition(ActivityBlackListParam activityBlackListParam) {
        return selectList("listByCondition", activityBlackListParam);
    }

    @Override
    public Integer selectCountByCondition(ActivityBlackListParam activityBlackListParam) {
        return selectOne("selectCountByCondition", activityBlackListParam);
    }

    @Override
    public ActivityBlackListDto findByCustomerId(Long customerId) {
        return selectOne("findByCustomerId", customerId);
    }
}
