package cn.com.duiba.anticheat.center.biz.dao.risk.impl;

import cn.com.duiba.anticheat.center.api.param.RiskRouteParam;
import cn.com.duiba.anticheat.center.biz.dao.BaseDao;
import cn.com.duiba.anticheat.center.biz.dao.DatabaseSchema;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskRouteConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskRouteConfigEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Repository
public class RiskRouteConfigDaoImpl extends BaseDao implements RiskRouteConfigDao {

    @PostConstruct
    private void init() {
        this.databaseSchema = DatabaseSchema.DEVELOPER_APP;
    }

    @Override
    public int save(RiskRouteConfigEntity riskRouteConfigEntity){
        return insert("save", riskRouteConfigEntity);
    }

    @Override
    public int updateById(RiskRouteConfigEntity riskRouteConfigEntity){
        return update("updateById",riskRouteConfigEntity);
    }

    @Override
    public RiskRouteConfigEntity getById(Long id){
        return selectOne("getById",id);
    }

    @Override
    public List<RiskRouteConfigEntity> listByParams(RiskRouteParam param) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("bizType",param.getBizType());
        map.put("projectLabel",param.getProjectLabel());
        map.put("activityType", param.getActivityType());
        map.put("projectId",param.getProjectId());
        map.put("scene", param.getScene());
        if(!Objects.isNull(param.getPageNo()) && !Objects.isNull(param.getPageSize())){
            map.put("max",param.getPageSize());
            map.put("offset", (param.getPageNo() - 1) * param.getPageSize());
        }
        return selectList("listByParams",map);
    }

    @Override
    public int countByParams(RiskRouteParam param) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("bizType",param.getBizType());
        map.put("projectLabel",param.getProjectLabel());
        map.put("activityType", param.getActivityType());
        map.put("projectId",param.getProjectId());
        map.put("scene", param.getScene());
        return selectOne("countByParams",map);
    }


}
